/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class IamResourceValue {
    public static final IamResourceValue PROJECT = new IamResourceValue("project");
    public static final IamResourceValue FILE = new IamResourceValue("file");
    public static final IamResourceValue FOLDER = new IamResourceValue("folder");
    public static final IamResourceValue PRODUCT = new IamResourceValue("product");
    public static final IamResourceValue PROPERTY = new IamResourceValue("property");
    public static final IamResourceValue USER = new IamResourceValue("user");
    public static final IamResourceValue UNMAPPED_VALUE = new IamResourceValue("unmapped_value");
    private static final Map<String, IamResourceValue> values = IamResourceValue.createValuesMap();
    private static final Map<String, IamResourceValueEnum> enums = IamResourceValue.createEnumsMap();
    private final String value;

    private IamResourceValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamResourceValue of(String value) {
        Class<IamResourceValue> clazz = IamResourceValue.class;
        synchronized (IamResourceValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamResourceValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<IamResourceValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamResourceValue other = (IamResourceValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamResourceValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamResourceValue[] values() {
        Class<IamResourceValue> clazz = IamResourceValue.class;
        synchronized (IamResourceValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamResourceValue[0]);
        }
    }

    private static final Map<String, IamResourceValue> createValuesMap() {
        LinkedHashMap<String, IamResourceValue> map = new LinkedHashMap<String, IamResourceValue>();
        map.put("project", PROJECT);
        map.put("file", FILE);
        map.put("folder", FOLDER);
        map.put("product", PRODUCT);
        map.put("property", PROPERTY);
        map.put("user", USER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamResourceValueEnum> createEnumsMap() {
        HashMap<String, IamResourceValueEnum> map = new HashMap<String, IamResourceValueEnum>();
        map.put("project", IamResourceValueEnum.PROJECT);
        map.put("file", IamResourceValueEnum.FILE);
        map.put("folder", IamResourceValueEnum.FOLDER);
        map.put("product", IamResourceValueEnum.PRODUCT);
        map.put("property", IamResourceValueEnum.PROPERTY);
        map.put("user", IamResourceValueEnum.USER);
        map.put("unmapped_value", IamResourceValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum IamResourceValueEnum {
        PROJECT("project"),
        FILE("file"),
        FOLDER("folder"),
        PRODUCT("product"),
        PROPERTY("property"),
        USER("user"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private IamResourceValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<IamResourceValue> {
        protected _Deserializer() {
            super(IamResourceValue.class);
        }

        public IamResourceValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return IamResourceValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<IamResourceValue> {
        protected _Serializer() {
            super(IamResourceValue.class);
        }

        public void serialize(IamResourceValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

