/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class LinkedAccountType {
    public static final LinkedAccountType PRODUCTION = new LinkedAccountType("production");
    public static final LinkedAccountType TEST = new LinkedAccountType("test");
    public static final LinkedAccountType UNMAPPED_VALUE = new LinkedAccountType("unmapped_value");
    private static final Map<String, LinkedAccountType> values = LinkedAccountType.createValuesMap();
    private static final Map<String, LinkedAccountTypeEnum> enums = LinkedAccountType.createEnumsMap();
    private final String value;

    private LinkedAccountType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedAccountType of(String value) {
        Class<LinkedAccountType> clazz = LinkedAccountType.class;
        synchronized (LinkedAccountType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new LinkedAccountType((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<LinkedAccountTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedAccountType other = (LinkedAccountType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "LinkedAccountType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedAccountType[] values() {
        Class<LinkedAccountType> clazz = LinkedAccountType.class;
        synchronized (LinkedAccountType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new LinkedAccountType[0]);
        }
    }

    private static final Map<String, LinkedAccountType> createValuesMap() {
        LinkedHashMap<String, LinkedAccountType> map = new LinkedHashMap<String, LinkedAccountType>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, LinkedAccountTypeEnum> createEnumsMap() {
        HashMap<String, LinkedAccountTypeEnum> map = new HashMap<String, LinkedAccountTypeEnum>();
        map.put("production", LinkedAccountTypeEnum.PRODUCTION);
        map.put("test", LinkedAccountTypeEnum.TEST);
        map.put("unmapped_value", LinkedAccountTypeEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum LinkedAccountTypeEnum {
        PRODUCTION("production"),
        TEST("test"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private LinkedAccountTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<LinkedAccountType> {
        protected _Deserializer() {
            super(LinkedAccountType.class);
        }

        public LinkedAccountType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return LinkedAccountType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<LinkedAccountType> {
        protected _Serializer() {
            super(LinkedAccountType.class);
        }

        public void serialize(LinkedAccountType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

