/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class Url {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="hostname")
    private JsonNullable<String> hostname;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="path")
    private JsonNullable<String> path;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="query_params")
    private JsonNullable<? extends Map<String, Object>> queryParams;

    @JsonCreator
    public Url(@JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="hostname") JsonNullable<String> hostname, @JsonProperty(value="path") JsonNullable<String> path, @JsonProperty(value="query_params") JsonNullable<? extends Map<String, Object>> queryParams) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(hostname, "hostname");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(queryParams, "queryParams");
        this.url = url;
        this.hostname = hostname;
        this.path = path;
        this.queryParams = queryParams;
    }

    public Url() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<String> hostname() {
        return this.hostname;
    }

    @JsonIgnore
    public JsonNullable<String> path() {
        return this.path;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> queryParams() {
        return this.queryParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Url withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public Url withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Url withHostname(String hostname) {
        Utils.checkNotNull(hostname, "hostname");
        this.hostname = JsonNullable.of((Object)hostname);
        return this;
    }

    public Url withHostname(JsonNullable<String> hostname) {
        Utils.checkNotNull(hostname, "hostname");
        this.hostname = hostname;
        return this;
    }

    public Url withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of((Object)path);
        return this;
    }

    public Url withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    public Url withQueryParams(Map<String, Object> queryParams) {
        Utils.checkNotNull(queryParams, "queryParams");
        this.queryParams = JsonNullable.of(queryParams);
        return this;
    }

    public Url withQueryParams(JsonNullable<? extends Map<String, Object>> queryParams) {
        Utils.checkNotNull(queryParams, "queryParams");
        this.queryParams = queryParams;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Url other = (Url)o;
        return Utils.enhancedDeepEquals(this.url, other.url) && Utils.enhancedDeepEquals(this.hostname, other.hostname) && Utils.enhancedDeepEquals(this.path, other.path) && Utils.enhancedDeepEquals(this.queryParams, other.queryParams);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.url, this.hostname, this.path, this.queryParams);
    }

    public String toString() {
        return Utils.toString(Url.class, "url", this.url, "hostname", this.hostname, "path", this.path, "queryParams", this.queryParams);
    }

    public static final class Builder {
        private JsonNullable<String> url = JsonNullable.undefined();
        private JsonNullable<String> hostname = JsonNullable.undefined();
        private JsonNullable<String> path = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> queryParams = JsonNullable.undefined();

        private Builder() {
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder hostname(String hostname) {
            Utils.checkNotNull(hostname, "hostname");
            this.hostname = JsonNullable.of((Object)hostname);
            return this;
        }

        public Builder hostname(JsonNullable<String> hostname) {
            Utils.checkNotNull(hostname, "hostname");
            this.hostname = hostname;
            return this;
        }

        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of((Object)path);
            return this;
        }

        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        public Builder queryParams(Map<String, Object> queryParams) {
            Utils.checkNotNull(queryParams, "queryParams");
            this.queryParams = JsonNullable.of(queryParams);
            return this;
        }

        public Builder queryParams(JsonNullable<? extends Map<String, Object>> queryParams) {
            Utils.checkNotNull(queryParams, "queryParams");
            this.queryParams = queryParams;
            return this;
        }

        public Url build() {
            return new Url(this.url, this.hostname, this.path, this.queryParams);
        }
    }
}

