/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingListCompanyJournalsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingJournalsPaginated> accountingJournalsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingListCompanyJournalsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingJournalsPaginated> accountingJournalsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingJournalsPaginated, "accountingJournalsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingJournalsPaginated = accountingJournalsPaginated;
        this.headers = headers;
    }

    public AccountingListCompanyJournalsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingJournalsPaginated> accountingJournalsPaginated() {
        return this.accountingJournalsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingListCompanyJournalsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingListCompanyJournalsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingListCompanyJournalsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingListCompanyJournalsResponse withAccountingJournalsPaginated(AccountingJournalsPaginated accountingJournalsPaginated) {
        Utils.checkNotNull(accountingJournalsPaginated, "accountingJournalsPaginated");
        this.accountingJournalsPaginated = Optional.ofNullable(accountingJournalsPaginated);
        return this;
    }

    public AccountingListCompanyJournalsResponse withAccountingJournalsPaginated(Optional<? extends AccountingJournalsPaginated> accountingJournalsPaginated) {
        Utils.checkNotNull(accountingJournalsPaginated, "accountingJournalsPaginated");
        this.accountingJournalsPaginated = accountingJournalsPaginated;
        return this;
    }

    public AccountingListCompanyJournalsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingListCompanyJournalsResponse other = (AccountingListCompanyJournalsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingJournalsPaginated, other.accountingJournalsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingJournalsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingListCompanyJournalsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingJournalsPaginated", this.accountingJournalsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingJournalsPaginated> accountingJournalsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingJournalsPaginated(AccountingJournalsPaginated accountingJournalsPaginated) {
            Utils.checkNotNull(accountingJournalsPaginated, "accountingJournalsPaginated");
            this.accountingJournalsPaginated = Optional.ofNullable(accountingJournalsPaginated);
            return this;
        }

        public Builder accountingJournalsPaginated(Optional<? extends AccountingJournalsPaginated> accountingJournalsPaginated) {
            Utils.checkNotNull(accountingJournalsPaginated, "accountingJournalsPaginated");
            this.accountingJournalsPaginated = accountingJournalsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingListCompanyJournalsResponse build() {
            return new AccountingListCompanyJournalsResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingJournalsPaginated, this.headers);
        }
    }
}

