/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingTaxRatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingListCompanyTaxRatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingTaxRatesPaginated> accountingTaxRatesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingListCompanyTaxRatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingTaxRatesPaginated> accountingTaxRatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingTaxRatesPaginated, "accountingTaxRatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingTaxRatesPaginated = accountingTaxRatesPaginated;
        this.headers = headers;
    }

    public AccountingListCompanyTaxRatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingTaxRatesPaginated> accountingTaxRatesPaginated() {
        return this.accountingTaxRatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingListCompanyTaxRatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingListCompanyTaxRatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingListCompanyTaxRatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingListCompanyTaxRatesResponse withAccountingTaxRatesPaginated(AccountingTaxRatesPaginated accountingTaxRatesPaginated) {
        Utils.checkNotNull(accountingTaxRatesPaginated, "accountingTaxRatesPaginated");
        this.accountingTaxRatesPaginated = Optional.ofNullable(accountingTaxRatesPaginated);
        return this;
    }

    public AccountingListCompanyTaxRatesResponse withAccountingTaxRatesPaginated(Optional<? extends AccountingTaxRatesPaginated> accountingTaxRatesPaginated) {
        Utils.checkNotNull(accountingTaxRatesPaginated, "accountingTaxRatesPaginated");
        this.accountingTaxRatesPaginated = accountingTaxRatesPaginated;
        return this;
    }

    public AccountingListCompanyTaxRatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingListCompanyTaxRatesResponse other = (AccountingListCompanyTaxRatesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingTaxRatesPaginated, other.accountingTaxRatesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingTaxRatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingListCompanyTaxRatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingTaxRatesPaginated", this.accountingTaxRatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingTaxRatesPaginated> accountingTaxRatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingTaxRatesPaginated(AccountingTaxRatesPaginated accountingTaxRatesPaginated) {
            Utils.checkNotNull(accountingTaxRatesPaginated, "accountingTaxRatesPaginated");
            this.accountingTaxRatesPaginated = Optional.ofNullable(accountingTaxRatesPaginated);
            return this;
        }

        public Builder accountingTaxRatesPaginated(Optional<? extends AccountingTaxRatesPaginated> accountingTaxRatesPaginated) {
            Utils.checkNotNull(accountingTaxRatesPaginated, "accountingTaxRatesPaginated");
            this.accountingTaxRatesPaginated = accountingTaxRatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingListCompanyTaxRatesResponse build() {
            return new AccountingListCompanyTaxRatesResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingTaxRatesPaginated, this.headers);
        }
    }
}

