/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JobPostingResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetJobPostingResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends JobPostingResult> jobPostingResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetJobPostingResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends JobPostingResult> jobPostingResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jobPostingResult, "jobPostingResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jobPostingResult = jobPostingResult;
        this.headers = headers;
    }

    public AtsGetJobPostingResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<JobPostingResult> jobPostingResult() {
        return this.jobPostingResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetJobPostingResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetJobPostingResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetJobPostingResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetJobPostingResponse withJobPostingResult(JobPostingResult jobPostingResult) {
        Utils.checkNotNull(jobPostingResult, "jobPostingResult");
        this.jobPostingResult = Optional.ofNullable(jobPostingResult);
        return this;
    }

    public AtsGetJobPostingResponse withJobPostingResult(Optional<? extends JobPostingResult> jobPostingResult) {
        Utils.checkNotNull(jobPostingResult, "jobPostingResult");
        this.jobPostingResult = jobPostingResult;
        return this;
    }

    public AtsGetJobPostingResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetJobPostingResponse other = (AtsGetJobPostingResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.jobPostingResult, other.jobPostingResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.jobPostingResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetJobPostingResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jobPostingResult", this.jobPostingResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends JobPostingResult> jobPostingResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jobPostingResult(JobPostingResult jobPostingResult) {
            Utils.checkNotNull(jobPostingResult, "jobPostingResult");
            this.jobPostingResult = Optional.ofNullable(jobPostingResult);
            return this;
        }

        public Builder jobPostingResult(Optional<? extends JobPostingResult> jobPostingResult) {
            Utils.checkNotNull(jobPostingResult, "jobPostingResult");
            this.jobPostingResult = jobPostingResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetJobPostingResponse build() {
            return new AtsGetJobPostingResponse(this.contentType, this.statusCode, this.rawResponse, this.jobPostingResult, this.headers);
        }
    }
}

