/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListCandidatesRequest;
import com.stackone.stackone_client_java.models.operations.AtsListCandidatesResponse;
import com.stackone.stackone_client_java.operations.AtsListCandidates;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListCandidatesRequestBuilder {
    private AtsListCandidatesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsListCandidatesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListCandidatesRequestBuilder request(AtsListCandidatesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListCandidatesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListCandidatesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListCandidatesResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListCandidates.Sync operation = new AtsListCandidates.Sync(this.sdkConfiguration, options, this._headers);
        return (AtsListCandidatesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListCandidatesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListCandidates.Sync operation = new AtsListCandidates.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AtsListCandidatesRequest, String> iterator = new Paginator<AtsListCandidatesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListCandidatesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListCandidatesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

