/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsDocumentsUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUploadApplicationDocumentRequest;
import com.stackone.stackone_client_java.models.operations.AtsUploadApplicationDocumentResponse;
import com.stackone.stackone_client_java.operations.AtsUploadApplicationDocument;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUploadApplicationDocumentRequestBuilder {
    private String xAccountId;
    private String id;
    private AtsDocumentsUploadRequestDto atsDocumentsUploadRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsUploadApplicationDocumentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUploadApplicationDocumentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder atsDocumentsUploadRequestDto(AtsDocumentsUploadRequestDto atsDocumentsUploadRequestDto) {
        Utils.checkNotNull(atsDocumentsUploadRequestDto, "atsDocumentsUploadRequestDto");
        this.atsDocumentsUploadRequestDto = atsDocumentsUploadRequestDto;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUploadApplicationDocumentRequest buildRequest() {
        AtsUploadApplicationDocumentRequest request = new AtsUploadApplicationDocumentRequest(this.xAccountId, this.id, this.atsDocumentsUploadRequestDto);
        return request;
    }

    public AtsUploadApplicationDocumentResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUploadApplicationDocument.Sync operation = new AtsUploadApplicationDocument.Sync(this.sdkConfiguration, options, this._headers);
        AtsUploadApplicationDocumentRequest request = this.buildRequest();
        return (AtsUploadApplicationDocumentResponse)operation.handleResponse(operation.doRequest(request));
    }
}

