/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffBalanceResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetEmployeeTimeOffBalanceResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TimeOffBalanceResult> timeOffBalanceResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetEmployeeTimeOffBalanceResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TimeOffBalanceResult> timeOffBalanceResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffBalanceResult, "timeOffBalanceResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffBalanceResult = timeOffBalanceResult;
        this.headers = headers;
    }

    public HrisGetEmployeeTimeOffBalanceResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeOffBalanceResult> timeOffBalanceResult() {
        return this.timeOffBalanceResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetEmployeeTimeOffBalanceResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetEmployeeTimeOffBalanceResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetEmployeeTimeOffBalanceResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetEmployeeTimeOffBalanceResponse withTimeOffBalanceResult(TimeOffBalanceResult timeOffBalanceResult) {
        Utils.checkNotNull(timeOffBalanceResult, "timeOffBalanceResult");
        this.timeOffBalanceResult = Optional.ofNullable(timeOffBalanceResult);
        return this;
    }

    public HrisGetEmployeeTimeOffBalanceResponse withTimeOffBalanceResult(Optional<? extends TimeOffBalanceResult> timeOffBalanceResult) {
        Utils.checkNotNull(timeOffBalanceResult, "timeOffBalanceResult");
        this.timeOffBalanceResult = timeOffBalanceResult;
        return this;
    }

    public HrisGetEmployeeTimeOffBalanceResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeeTimeOffBalanceResponse other = (HrisGetEmployeeTimeOffBalanceResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.timeOffBalanceResult, other.timeOffBalanceResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.timeOffBalanceResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetEmployeeTimeOffBalanceResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeOffBalanceResult", this.timeOffBalanceResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TimeOffBalanceResult> timeOffBalanceResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeOffBalanceResult(TimeOffBalanceResult timeOffBalanceResult) {
            Utils.checkNotNull(timeOffBalanceResult, "timeOffBalanceResult");
            this.timeOffBalanceResult = Optional.ofNullable(timeOffBalanceResult);
            return this;
        }

        public Builder timeOffBalanceResult(Optional<? extends TimeOffBalanceResult> timeOffBalanceResult) {
            Utils.checkNotNull(timeOffBalanceResult, "timeOffBalanceResult");
            this.timeOffBalanceResult = timeOffBalanceResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetEmployeeTimeOffBalanceResponse build() {
            return new HrisGetEmployeeTimeOffBalanceResponse(this.contentType, this.statusCode, this.rawResponse, this.timeOffBalanceResult, this.headers);
        }
    }
}

