/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISLocationResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetLocationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISLocationResult> hrisLocationResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetLocationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISLocationResult> hrisLocationResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisLocationResult, "hrisLocationResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisLocationResult = hrisLocationResult;
        this.headers = headers;
    }

    public HrisGetLocationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISLocationResult> hrisLocationResult() {
        return this.hrisLocationResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetLocationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetLocationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetLocationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetLocationResponse withHRISLocationResult(HRISLocationResult hrisLocationResult) {
        Utils.checkNotNull(hrisLocationResult, "hrisLocationResult");
        this.hrisLocationResult = Optional.ofNullable(hrisLocationResult);
        return this;
    }

    public HrisGetLocationResponse withHRISLocationResult(Optional<? extends HRISLocationResult> hrisLocationResult) {
        Utils.checkNotNull(hrisLocationResult, "hrisLocationResult");
        this.hrisLocationResult = hrisLocationResult;
        return this;
    }

    public HrisGetLocationResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetLocationResponse other = (HrisGetLocationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisLocationResult, other.hrisLocationResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisLocationResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetLocationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisLocationResult", this.hrisLocationResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISLocationResult> hrisLocationResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisLocationResult(HRISLocationResult hrisLocationResult) {
            Utils.checkNotNull(hrisLocationResult, "hrisLocationResult");
            this.hrisLocationResult = Optional.ofNullable(hrisLocationResult);
            return this;
        }

        public Builder hrisLocationResult(Optional<? extends HRISLocationResult> hrisLocationResult) {
            Utils.checkNotNull(hrisLocationResult, "hrisLocationResult");
            this.hrisLocationResult = hrisLocationResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetLocationResponse build() {
            return new HrisGetLocationResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisLocationResult, this.headers);
        }
    }
}

