/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssignmentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LmsGetAssignmentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AssignmentResult> assignmentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsGetAssignmentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AssignmentResult> assignmentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assignmentResult, "assignmentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assignmentResult = assignmentResult;
        this.headers = headers;
    }

    public LmsGetAssignmentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssignmentResult> assignmentResult() {
        return this.assignmentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsGetAssignmentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsGetAssignmentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsGetAssignmentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsGetAssignmentResponse withAssignmentResult(AssignmentResult assignmentResult) {
        Utils.checkNotNull(assignmentResult, "assignmentResult");
        this.assignmentResult = Optional.ofNullable(assignmentResult);
        return this;
    }

    public LmsGetAssignmentResponse withAssignmentResult(Optional<? extends AssignmentResult> assignmentResult) {
        Utils.checkNotNull(assignmentResult, "assignmentResult");
        this.assignmentResult = assignmentResult;
        return this;
    }

    public LmsGetAssignmentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsGetAssignmentResponse other = (LmsGetAssignmentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.assignmentResult, other.assignmentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.assignmentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsGetAssignmentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assignmentResult", this.assignmentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AssignmentResult> assignmentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assignmentResult(AssignmentResult assignmentResult) {
            Utils.checkNotNull(assignmentResult, "assignmentResult");
            this.assignmentResult = Optional.ofNullable(assignmentResult);
            return this;
        }

        public Builder assignmentResult(Optional<? extends AssignmentResult> assignmentResult) {
            Utils.checkNotNull(assignmentResult, "assignmentResult");
            this.assignmentResult = assignmentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsGetAssignmentResponse build() {
            return new LmsGetAssignmentResponse(this.contentType, this.statusCode, this.rawResponse, this.assignmentResult, this.headers);
        }
    }
}

