/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.LmsUpsertContentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsUpsertContentRequest;
import com.stackone.stackone_client_java.models.operations.LmsUpsertContentResponse;
import com.stackone.stackone_client_java.operations.LmsUpsertContent;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsUpsertContentRequestBuilder {
    private String xAccountId;
    private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public LmsUpsertContentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsUpsertContentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpsertContentRequestBuilder lmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
        return this;
    }

    public LmsUpsertContentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsUpsertContentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private LmsUpsertContentRequest buildRequest() {
        LmsUpsertContentRequest request = new LmsUpsertContentRequest(this.xAccountId, this.lmsUpsertContentRequestDto);
        return request;
    }

    public LmsUpsertContentResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsUpsertContent.Sync operation = new LmsUpsertContent.Sync(this.sdkConfiguration, options, this._headers);
        LmsUpsertContentRequest request = this.buildRequest();
        return (LmsUpsertContentResponse)operation.handleResponse(operation.doRequest(request));
    }
}

