/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingMessagesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MessagingListConversationMessagesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MessagingMessagesPaginated> messagingMessagesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingListConversationMessagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MessagingMessagesPaginated> messagingMessagesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingMessagesPaginated, "messagingMessagesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingMessagesPaginated = messagingMessagesPaginated;
        this.headers = headers;
    }

    public MessagingListConversationMessagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MessagingMessagesPaginated> messagingMessagesPaginated() {
        return this.messagingMessagesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingListConversationMessagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MessagingListConversationMessagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MessagingListConversationMessagesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MessagingListConversationMessagesResponse withMessagingMessagesPaginated(MessagingMessagesPaginated messagingMessagesPaginated) {
        Utils.checkNotNull(messagingMessagesPaginated, "messagingMessagesPaginated");
        this.messagingMessagesPaginated = Optional.ofNullable(messagingMessagesPaginated);
        return this;
    }

    public MessagingListConversationMessagesResponse withMessagingMessagesPaginated(Optional<? extends MessagingMessagesPaginated> messagingMessagesPaginated) {
        Utils.checkNotNull(messagingMessagesPaginated, "messagingMessagesPaginated");
        this.messagingMessagesPaginated = messagingMessagesPaginated;
        return this;
    }

    public MessagingListConversationMessagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingListConversationMessagesResponse other = (MessagingListConversationMessagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.messagingMessagesPaginated, other.messagingMessagesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.messagingMessagesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MessagingListConversationMessagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "messagingMessagesPaginated", this.messagingMessagesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MessagingMessagesPaginated> messagingMessagesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder messagingMessagesPaginated(MessagingMessagesPaginated messagingMessagesPaginated) {
            Utils.checkNotNull(messagingMessagesPaginated, "messagingMessagesPaginated");
            this.messagingMessagesPaginated = Optional.ofNullable(messagingMessagesPaginated);
            return this;
        }

        public Builder messagingMessagesPaginated(Optional<? extends MessagingMessagesPaginated> messagingMessagesPaginated) {
            Utils.checkNotNull(messagingMessagesPaginated, "messagingMessagesPaginated");
            this.messagingMessagesPaginated = messagingMessagesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingListConversationMessagesResponse build() {
            return new MessagingListConversationMessagesResponse(this.contentType, this.statusCode, this.rawResponse, this.messagingMessagesPaginated, this.headers);
        }
    }
}

