/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsResponse;
import com.stackone.stackone_client_java.operations.MessagingListConversations;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MessagingListConversationsRequestBuilder {
    private MessagingListConversationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MessagingListConversationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingListConversationsRequestBuilder request(MessagingListConversationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingListConversationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingListConversationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MessagingListConversationsResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListConversations.Sync operation = new MessagingListConversations.Sync(this.sdkConfiguration, options, this._headers);
        return (MessagingListConversationsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MessagingListConversationsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListConversations.Sync operation = new MessagingListConversations.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<MessagingListConversationsRequest, String> iterator = new Paginator<MessagingListConversationsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MessagingListConversationsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MessagingListConversationsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

