/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetConnectorMetaRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=provider")
    private String provider;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include")
    private JsonNullable<String> include;

    @JsonCreator
    public StackoneGetConnectorMetaRequest(String provider, JsonNullable<String> include) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(include, "include");
        this.provider = provider;
        this.include = include;
    }

    public StackoneGetConnectorMetaRequest(String provider) {
        this(provider, (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public JsonNullable<String> include() {
        return this.include;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneGetConnectorMetaRequest withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public StackoneGetConnectorMetaRequest withInclude(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)include);
        return this;
    }

    public StackoneGetConnectorMetaRequest withInclude(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneGetConnectorMetaRequest other = (StackoneGetConnectorMetaRequest)o;
        return Utils.enhancedDeepEquals(this.provider, other.provider) && Utils.enhancedDeepEquals(this.include, other.include);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.provider, this.include);
    }

    public String toString() {
        return Utils.toString(StackoneGetConnectorMetaRequest.class, "provider", this.provider, "include", this.include);
    }

    public static final class Builder {
        private String provider;
        private JsonNullable<String> include = JsonNullable.undefined();

        private Builder() {
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder include(String include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of((Object)include);
            return this;
        }

        public Builder include(JsonNullable<String> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public StackoneGetConnectorMetaRequest build() {
            return new StackoneGetConnectorMetaRequest(this.provider, this.include);
        }
    }
}

