/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpDeleteRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private Optional<String> xAccountId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=x-account-id")
    private Optional<? extends Object> xAccountIdQueryParameter;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=mcp-session-id")
    private String mcpSessionId;

    @JsonCreator
    public StackoneMcpDeleteRequest(Optional<String> xAccountId, Optional<? extends Object> xAccountIdQueryParameter, String mcpSessionId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.xAccountId = xAccountId;
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        this.mcpSessionId = mcpSessionId;
    }

    public StackoneMcpDeleteRequest(String mcpSessionId) {
        this(Optional.empty(), Optional.empty(), mcpSessionId);
    }

    @JsonIgnore
    public Optional<String> xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<Object> xAccountIdQueryParameter() {
        return this.xAccountIdQueryParameter;
    }

    @JsonIgnore
    public String mcpSessionId() {
        return this.mcpSessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneMcpDeleteRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = Optional.ofNullable(xAccountId);
        return this;
    }

    public StackoneMcpDeleteRequest withXAccountId(Optional<String> xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpDeleteRequest withXAccountIdQueryParameter(Object xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
        return this;
    }

    public StackoneMcpDeleteRequest withXAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        return this;
    }

    public StackoneMcpDeleteRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpDeleteRequest other = (StackoneMcpDeleteRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.xAccountIdQueryParameter, other.xAccountIdQueryParameter) && Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.xAccountIdQueryParameter, this.mcpSessionId);
    }

    public String toString() {
        return Utils.toString(StackoneMcpDeleteRequest.class, "xAccountId", this.xAccountId, "xAccountIdQueryParameter", this.xAccountIdQueryParameter, "mcpSessionId", this.mcpSessionId);
    }

    public static final class Builder {
        private Optional<String> xAccountId = Optional.empty();
        private Optional<? extends Object> xAccountIdQueryParameter = Optional.empty();
        private String mcpSessionId;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = Optional.ofNullable(xAccountId);
            return this;
        }

        public Builder xAccountId(Optional<String> xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder xAccountIdQueryParameter(Object xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
            return this;
        }

        public Builder xAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = xAccountIdQueryParameter;
            return this;
        }

        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public StackoneMcpDeleteRequest build() {
            return new StackoneMcpDeleteRequest(this.xAccountId, this.xAccountIdQueryParameter, this.mcpSessionId);
        }
    }
}

