/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingCommentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetCommentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingCommentResult> ticketingCommentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetCommentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingCommentResult> ticketingCommentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingCommentResult, "ticketingCommentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingCommentResult = ticketingCommentResult;
        this.headers = headers;
    }

    public TicketingGetCommentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingCommentResult> ticketingCommentResult() {
        return this.ticketingCommentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetCommentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetCommentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetCommentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetCommentResponse withTicketingCommentResult(TicketingCommentResult ticketingCommentResult) {
        Utils.checkNotNull(ticketingCommentResult, "ticketingCommentResult");
        this.ticketingCommentResult = Optional.ofNullable(ticketingCommentResult);
        return this;
    }

    public TicketingGetCommentResponse withTicketingCommentResult(Optional<? extends TicketingCommentResult> ticketingCommentResult) {
        Utils.checkNotNull(ticketingCommentResult, "ticketingCommentResult");
        this.ticketingCommentResult = ticketingCommentResult;
        return this;
    }

    public TicketingGetCommentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetCommentResponse other = (TicketingGetCommentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingCommentResult, other.ticketingCommentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingCommentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetCommentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingCommentResult", this.ticketingCommentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingCommentResult> ticketingCommentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingCommentResult(TicketingCommentResult ticketingCommentResult) {
            Utils.checkNotNull(ticketingCommentResult, "ticketingCommentResult");
            this.ticketingCommentResult = Optional.ofNullable(ticketingCommentResult);
            return this;
        }

        public Builder ticketingCommentResult(Optional<? extends TicketingCommentResult> ticketingCommentResult) {
            Utils.checkNotNull(ticketingCommentResult, "ticketingCommentResult");
            this.ticketingCommentResult = ticketingCommentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetCommentResponse build() {
            return new TicketingGetCommentResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingCommentResult, this.headers);
        }
    }
}

