/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketStatusesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListTicketStatusesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListTicketStatusesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingTicketStatusesPaginated, "ticketingTicketStatusesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingTicketStatusesPaginated = ticketingTicketStatusesPaginated;
        this.headers = headers;
    }

    public TicketingListTicketStatusesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated() {
        return this.ticketingTicketStatusesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListTicketStatusesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListTicketStatusesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListTicketStatusesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListTicketStatusesResponse withTicketingTicketStatusesPaginated(TicketingTicketStatusesPaginated ticketingTicketStatusesPaginated) {
        Utils.checkNotNull(ticketingTicketStatusesPaginated, "ticketingTicketStatusesPaginated");
        this.ticketingTicketStatusesPaginated = Optional.ofNullable(ticketingTicketStatusesPaginated);
        return this;
    }

    public TicketingListTicketStatusesResponse withTicketingTicketStatusesPaginated(Optional<? extends TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated) {
        Utils.checkNotNull(ticketingTicketStatusesPaginated, "ticketingTicketStatusesPaginated");
        this.ticketingTicketStatusesPaginated = ticketingTicketStatusesPaginated;
        return this;
    }

    public TicketingListTicketStatusesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListTicketStatusesResponse other = (TicketingListTicketStatusesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingTicketStatusesPaginated, other.ticketingTicketStatusesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketStatusesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListTicketStatusesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingTicketStatusesPaginated", this.ticketingTicketStatusesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingTicketStatusesPaginated(TicketingTicketStatusesPaginated ticketingTicketStatusesPaginated) {
            Utils.checkNotNull(ticketingTicketStatusesPaginated, "ticketingTicketStatusesPaginated");
            this.ticketingTicketStatusesPaginated = Optional.ofNullable(ticketingTicketStatusesPaginated);
            return this;
        }

        public Builder ticketingTicketStatusesPaginated(Optional<? extends TicketingTicketStatusesPaginated> ticketingTicketStatusesPaginated) {
            Utils.checkNotNull(ticketingTicketStatusesPaginated, "ticketingTicketStatusesPaginated");
            this.ticketingTicketStatusesPaginated = ticketingTicketStatusesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListTicketStatusesResponse build() {
            return new TicketingListTicketStatusesResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketStatusesPaginated, this.headers);
        }
    }
}

