/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingCompanyResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingGetCompanyResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AccountingCompanyResult> accountingCompanyResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AccountingCompanyResult> accountingCompanyResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingCompanyResult = accountingCompanyResult;
        this.headers = headers;
    }

    public AccountingGetCompanyResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingCompanyResult> accountingCompanyResult() {
        return this.accountingCompanyResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingGetCompanyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingGetCompanyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingGetCompanyResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingGetCompanyResponse withAccountingCompanyResult(AccountingCompanyResult accountingCompanyResult) {
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        this.accountingCompanyResult = Optional.ofNullable(accountingCompanyResult);
        return this;
    }

    public AccountingGetCompanyResponse withAccountingCompanyResult(Optional<? extends AccountingCompanyResult> accountingCompanyResult) {
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        this.accountingCompanyResult = accountingCompanyResult;
        return this;
    }

    public AccountingGetCompanyResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyResponse other = (AccountingGetCompanyResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingCompanyResult, other.accountingCompanyResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingCompanyResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingGetCompanyResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingCompanyResult", this.accountingCompanyResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AccountingCompanyResult> accountingCompanyResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingCompanyResult(AccountingCompanyResult accountingCompanyResult) {
            Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
            this.accountingCompanyResult = Optional.ofNullable(accountingCompanyResult);
            return this;
        }

        public Builder accountingCompanyResult(Optional<? extends AccountingCompanyResult> accountingCompanyResult) {
            Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
            this.accountingCompanyResult = accountingCompanyResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyResponse build() {
            return new AccountingGetCompanyResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingCompanyResult, this.headers);
        }
    }
}

