/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScheduledInterviewsResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetApplicationScheduledInterviewResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ScheduledInterviewsResult> scheduledInterviewsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetApplicationScheduledInterviewResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ScheduledInterviewsResult> scheduledInterviewsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(scheduledInterviewsResult, "scheduledInterviewsResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.scheduledInterviewsResult = scheduledInterviewsResult;
        this.headers = headers;
    }

    public AtsGetApplicationScheduledInterviewResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScheduledInterviewsResult> scheduledInterviewsResult() {
        return this.scheduledInterviewsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetApplicationScheduledInterviewResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetApplicationScheduledInterviewResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetApplicationScheduledInterviewResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetApplicationScheduledInterviewResponse withScheduledInterviewsResult(ScheduledInterviewsResult scheduledInterviewsResult) {
        Utils.checkNotNull(scheduledInterviewsResult, "scheduledInterviewsResult");
        this.scheduledInterviewsResult = Optional.ofNullable(scheduledInterviewsResult);
        return this;
    }

    public AtsGetApplicationScheduledInterviewResponse withScheduledInterviewsResult(Optional<? extends ScheduledInterviewsResult> scheduledInterviewsResult) {
        Utils.checkNotNull(scheduledInterviewsResult, "scheduledInterviewsResult");
        this.scheduledInterviewsResult = scheduledInterviewsResult;
        return this;
    }

    public AtsGetApplicationScheduledInterviewResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetApplicationScheduledInterviewResponse other = (AtsGetApplicationScheduledInterviewResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.scheduledInterviewsResult, other.scheduledInterviewsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetApplicationScheduledInterviewResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "scheduledInterviewsResult", this.scheduledInterviewsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ScheduledInterviewsResult> scheduledInterviewsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder scheduledInterviewsResult(ScheduledInterviewsResult scheduledInterviewsResult) {
            Utils.checkNotNull(scheduledInterviewsResult, "scheduledInterviewsResult");
            this.scheduledInterviewsResult = Optional.ofNullable(scheduledInterviewsResult);
            return this;
        }

        public Builder scheduledInterviewsResult(Optional<? extends ScheduledInterviewsResult> scheduledInterviewsResult) {
            Utils.checkNotNull(scheduledInterviewsResult, "scheduledInterviewsResult");
            this.scheduledInterviewsResult = scheduledInterviewsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetApplicationScheduledInterviewResponse build() {
            return new AtsGetApplicationScheduledInterviewResponse(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsResult, this.headers);
        }
    }
}

