/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.RejectApplicationResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsRejectApplicationResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends RejectApplicationResult> rejectApplicationResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsRejectApplicationResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends RejectApplicationResult> rejectApplicationResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(rejectApplicationResult, "rejectApplicationResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.rejectApplicationResult = rejectApplicationResult;
        this.headers = headers;
    }

    public AtsRejectApplicationResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<RejectApplicationResult> rejectApplicationResult() {
        return this.rejectApplicationResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsRejectApplicationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsRejectApplicationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsRejectApplicationResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsRejectApplicationResponse withRejectApplicationResult(RejectApplicationResult rejectApplicationResult) {
        Utils.checkNotNull(rejectApplicationResult, "rejectApplicationResult");
        this.rejectApplicationResult = Optional.ofNullable(rejectApplicationResult);
        return this;
    }

    public AtsRejectApplicationResponse withRejectApplicationResult(Optional<? extends RejectApplicationResult> rejectApplicationResult) {
        Utils.checkNotNull(rejectApplicationResult, "rejectApplicationResult");
        this.rejectApplicationResult = rejectApplicationResult;
        return this;
    }

    public AtsRejectApplicationResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsRejectApplicationResponse other = (AtsRejectApplicationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.rejectApplicationResult, other.rejectApplicationResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.rejectApplicationResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsRejectApplicationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "rejectApplicationResult", this.rejectApplicationResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends RejectApplicationResult> rejectApplicationResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder rejectApplicationResult(RejectApplicationResult rejectApplicationResult) {
            Utils.checkNotNull(rejectApplicationResult, "rejectApplicationResult");
            this.rejectApplicationResult = Optional.ofNullable(rejectApplicationResult);
            return this;
        }

        public Builder rejectApplicationResult(Optional<? extends RejectApplicationResult> rejectApplicationResult) {
            Utils.checkNotNull(rejectApplicationResult, "rejectApplicationResult");
            this.rejectApplicationResult = rejectApplicationResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsRejectApplicationResponse build() {
            return new AtsRejectApplicationResponse(this.contentType, this.statusCode, this.rawResponse, this.rejectApplicationResult, this.headers);
        }
    }
}

