/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CrmListContactCustomFieldDefinitionsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public CrmListContactCustomFieldDefinitionsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        this.headers = headers;
    }

    public CrmListContactCustomFieldDefinitionsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated() {
        return this.customFieldDefinitionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CrmListContactCustomFieldDefinitionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CrmListContactCustomFieldDefinitionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CrmListContactCustomFieldDefinitionsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CrmListContactCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
        return this;
    }

    public CrmListContactCustomFieldDefinitionsResponse withCustomFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
        Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
        this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
        return this;
    }

    public CrmListContactCustomFieldDefinitionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmListContactCustomFieldDefinitionsResponse other = (CrmListContactCustomFieldDefinitionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.customFieldDefinitionsPaginated, other.customFieldDefinitionsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(CrmListContactCustomFieldDefinitionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "customFieldDefinitionsPaginated", this.customFieldDefinitionsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder customFieldDefinitionsPaginated(CustomFieldDefinitionsPaginated customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = Optional.ofNullable(customFieldDefinitionsPaginated);
            return this;
        }

        public Builder customFieldDefinitionsPaginated(Optional<? extends CustomFieldDefinitionsPaginated> customFieldDefinitionsPaginated) {
            Utils.checkNotNull(customFieldDefinitionsPaginated, "customFieldDefinitionsPaginated");
            this.customFieldDefinitionsPaginated = customFieldDefinitionsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public CrmListContactCustomFieldDefinitionsResponse build() {
            return new CrmListContactCustomFieldDefinitionsResponse(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionsPaginated, this.headers);
        }
    }
}

