/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISDivisionsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListDivisionGroupsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HRISDivisionsPaginated> hrisDivisionsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListDivisionGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HRISDivisionsPaginated> hrisDivisionsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDivisionsPaginated, "hrisDivisionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDivisionsPaginated = hrisDivisionsPaginated;
        this.headers = headers;
    }

    public HrisListDivisionGroupsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISDivisionsPaginated> hrisDivisionsPaginated() {
        return this.hrisDivisionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListDivisionGroupsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListDivisionGroupsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListDivisionGroupsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListDivisionGroupsResponse withHRISDivisionsPaginated(HRISDivisionsPaginated hrisDivisionsPaginated) {
        Utils.checkNotNull(hrisDivisionsPaginated, "hrisDivisionsPaginated");
        this.hrisDivisionsPaginated = Optional.ofNullable(hrisDivisionsPaginated);
        return this;
    }

    public HrisListDivisionGroupsResponse withHRISDivisionsPaginated(Optional<? extends HRISDivisionsPaginated> hrisDivisionsPaginated) {
        Utils.checkNotNull(hrisDivisionsPaginated, "hrisDivisionsPaginated");
        this.hrisDivisionsPaginated = hrisDivisionsPaginated;
        return this;
    }

    public HrisListDivisionGroupsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListDivisionGroupsResponse other = (HrisListDivisionGroupsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisDivisionsPaginated, other.hrisDivisionsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisDivisionsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListDivisionGroupsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisDivisionsPaginated", this.hrisDivisionsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HRISDivisionsPaginated> hrisDivisionsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisDivisionsPaginated(HRISDivisionsPaginated hrisDivisionsPaginated) {
            Utils.checkNotNull(hrisDivisionsPaginated, "hrisDivisionsPaginated");
            this.hrisDivisionsPaginated = Optional.ofNullable(hrisDivisionsPaginated);
            return this;
        }

        public Builder hrisDivisionsPaginated(Optional<? extends HRISDivisionsPaginated> hrisDivisionsPaginated) {
            Utils.checkNotNull(hrisDivisionsPaginated, "hrisDivisionsPaginated");
            this.hrisDivisionsPaginated = hrisDivisionsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListDivisionGroupsResponse build() {
            return new HrisListDivisionGroupsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisDivisionsPaginated, this.headers);
        }
    }
}

