/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeEntriesPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListTimeEntriesResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TimeEntriesPaginated> timeEntriesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListTimeEntriesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TimeEntriesPaginated> timeEntriesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeEntriesPaginated, "timeEntriesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeEntriesPaginated = timeEntriesPaginated;
        this.headers = headers;
    }

    public HrisListTimeEntriesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeEntriesPaginated> timeEntriesPaginated() {
        return this.timeEntriesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListTimeEntriesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListTimeEntriesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListTimeEntriesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListTimeEntriesResponse withTimeEntriesPaginated(TimeEntriesPaginated timeEntriesPaginated) {
        Utils.checkNotNull(timeEntriesPaginated, "timeEntriesPaginated");
        this.timeEntriesPaginated = Optional.ofNullable(timeEntriesPaginated);
        return this;
    }

    public HrisListTimeEntriesResponse withTimeEntriesPaginated(Optional<? extends TimeEntriesPaginated> timeEntriesPaginated) {
        Utils.checkNotNull(timeEntriesPaginated, "timeEntriesPaginated");
        this.timeEntriesPaginated = timeEntriesPaginated;
        return this;
    }

    public HrisListTimeEntriesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListTimeEntriesResponse other = (HrisListTimeEntriesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.timeEntriesPaginated, other.timeEntriesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.timeEntriesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListTimeEntriesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeEntriesPaginated", this.timeEntriesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TimeEntriesPaginated> timeEntriesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeEntriesPaginated(TimeEntriesPaginated timeEntriesPaginated) {
            Utils.checkNotNull(timeEntriesPaginated, "timeEntriesPaginated");
            this.timeEntriesPaginated = Optional.ofNullable(timeEntriesPaginated);
            return this;
        }

        public Builder timeEntriesPaginated(Optional<? extends TimeEntriesPaginated> timeEntriesPaginated) {
            Utils.checkNotNull(timeEntriesPaginated, "timeEntriesPaginated");
            this.timeEntriesPaginated = timeEntriesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListTimeEntriesResponse build() {
            return new HrisListTimeEntriesResponse(this.contentType, this.statusCode, this.rawResponse, this.timeEntriesPaginated, this.headers);
        }
    }
}

