/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.async.MessagingListAttachmentsResponse;
import com.stackone.stackone_client_java.operations.MessagingListAttachments;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class MessagingListAttachmentsRequestBuilder {
    private MessagingListAttachmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MessagingListAttachmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingListAttachmentsRequestBuilder request(MessagingListAttachmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingListAttachmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingListAttachmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<MessagingListAttachmentsResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListAttachments.Async operation = new MessagingListAttachments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<MessagingListAttachmentsResponse> callAsPublisher() {
        MessagingListAttachmentsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListAttachments.Async operation = new MessagingListAttachments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AsyncPaginator<MessagingListAttachmentsRequest, String> asyncPaginator = new AsyncPaginator<MessagingListAttachmentsRequest, String>(request, new CursorTracker<String>("$.next", String.class), MessagingListAttachmentsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

