/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.Include;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetLogResponse;
import com.stackone.stackone_client_java.operations.StackoneGetLog;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetLogRequestBuilder {
    private String id;
    private JsonNullable<? extends Include> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public StackoneGetLogRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneGetLogRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public StackoneGetLogRequestBuilder include(Include include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)((Object)include));
        return this;
    }

    public StackoneGetLogRequestBuilder include(JsonNullable<? extends Include> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public StackoneGetLogRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneGetLogRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneGetLogRequest buildRequest() {
        StackoneGetLogRequest request = new StackoneGetLogRequest(this.id, this.include);
        return request;
    }

    public CompletableFuture<StackoneGetLogResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneGetLog.Async operation = new StackoneGetLog.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        StackoneGetLogRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

