/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingComponentResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetProjectComponentResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingComponentResult> ticketingComponentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetProjectComponentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingComponentResult> ticketingComponentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingComponentResult, "ticketingComponentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingComponentResult = ticketingComponentResult;
        this.headers = headers;
    }

    public TicketingGetProjectComponentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingComponentResult> ticketingComponentResult() {
        return this.ticketingComponentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetProjectComponentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetProjectComponentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetProjectComponentResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetProjectComponentResponse withTicketingComponentResult(TicketingComponentResult ticketingComponentResult) {
        Utils.checkNotNull(ticketingComponentResult, "ticketingComponentResult");
        this.ticketingComponentResult = Optional.ofNullable(ticketingComponentResult);
        return this;
    }

    public TicketingGetProjectComponentResponse withTicketingComponentResult(Optional<? extends TicketingComponentResult> ticketingComponentResult) {
        Utils.checkNotNull(ticketingComponentResult, "ticketingComponentResult");
        this.ticketingComponentResult = ticketingComponentResult;
        return this;
    }

    public TicketingGetProjectComponentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetProjectComponentResponse other = (TicketingGetProjectComponentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingComponentResult, other.ticketingComponentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingComponentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetProjectComponentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingComponentResult", this.ticketingComponentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingComponentResult> ticketingComponentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingComponentResult(TicketingComponentResult ticketingComponentResult) {
            Utils.checkNotNull(ticketingComponentResult, "ticketingComponentResult");
            this.ticketingComponentResult = Optional.ofNullable(ticketingComponentResult);
            return this;
        }

        public Builder ticketingComponentResult(Optional<? extends TicketingComponentResult> ticketingComponentResult) {
            Utils.checkNotNull(ticketingComponentResult, "ticketingComponentResult");
            this.ticketingComponentResult = ticketingComponentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetProjectComponentResponse build() {
            return new TicketingGetProjectComponentResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingComponentResult, this.headers);
        }
    }
}

