/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.async.TicketingListAttachmentsResponse;
import com.stackone.stackone_client_java.operations.TicketingListAttachments;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class TicketingListAttachmentsRequestBuilder {
    private TicketingListAttachmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public TicketingListAttachmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListAttachmentsRequestBuilder request(TicketingListAttachmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListAttachmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListAttachmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<TicketingListAttachmentsResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListAttachments.Async operation = new TicketingListAttachments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<TicketingListAttachmentsResponse> callAsPublisher() {
        TicketingListAttachmentsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListAttachments.Async operation = new TicketingListAttachments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AsyncPaginator<TicketingListAttachmentsRequest, String> asyncPaginator = new AsyncPaginator<TicketingListAttachmentsRequest, String>(request, new CursorTracker<String>("$.next", String.class), TicketingListAttachmentsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

