/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.ConnectorsMeta;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.AsyncRetries;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StackoneGetConnectorMeta {

    public static class Async
    extends Base
    implements Operations.AsyncRequestOperation<StackoneGetConnectorMetaRequest, StackoneGetConnectorMetaResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(SDKConfiguration sdkConfiguration, Optional<Options> options, ScheduledExecutorService retryScheduler, Headers _headers) {
            super(sdkConfiguration, options, _headers);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(StackoneGetConnectorMetaRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, StackoneGetConnectorMetaRequest.class);
            return this.sdkConfiguration.asyncHooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(this.createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(StackoneGetConnectorMetaRequest request) {
            AsyncRetries retries = AsyncRetries.builder().retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).scheduler(this.retryScheduler).build();
            return retries.retry(() -> ((CompletableFuture)((CompletableFuture)Exceptions.unchecked(() -> this.onBuildRequest(request)).get().thenCompose(this.client::sendAsync)).handle((resp, err) -> {
                if (err != null) {
                    return this.onError(null, (Throwable)err);
                }
                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "408", "409", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                    return this.onError((HttpResponse<Blob>)resp, null);
                }
                return CompletableFuture.completedFuture(resp);
            })).thenCompose(Function.identity())).thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<StackoneGetConnectorMetaResponse> handleResponse(HttpResponse<Blob> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            StackoneGetConnectorMetaResponse.Builder resBuilder = StackoneGetConnectorMetaResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            StackoneGetConnectorMetaResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return Utils.unmarshalAsync(response, new TypeReference<ConnectorsMeta>(){}).thenApply(res::withConnectorsMeta);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadRequestResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnauthorizedResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ForbiddenResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotFoundResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return RequestTimedOutResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ConflictResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnprocessableEntityResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return TooManyRequestsResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return InternalServerErrorResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotImplementedResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadGatewayResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }

    public static class Sync
    extends Base
    implements Operations.RequestOperation<StackoneGetConnectorMetaRequest, com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            super(sdkConfiguration, options, _headers);
        }

        private HttpRequest onBuildRequest(StackoneGetConnectorMetaRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, StackoneGetConnectorMetaRequest.class);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(StackoneGetConnectorMetaRequest request) {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return Exceptions.unchecked(() -> this.onSuccess(retries.run())).get();
        }

        @Override
        public com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse handleResponse(HttpResponse<InputStream> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            StackoneGetConnectorMetaResponse.Builder resBuilder = com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return res.withConnectorsMeta(Utils.unmarshal(response, new TypeReference<ConnectorsMeta>(){}));
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadRequestResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnauthorizedResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ForbiddenResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotFoundResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw RequestTimedOutResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ConflictResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnprocessableEntityResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw TooManyRequestsResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw InternalServerErrorResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotImplementedResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadGatewayResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw SDKError.from("API error occurred", response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw SDKError.from("API error occurred", response);
            }
            throw SDKError.from("Unexpected status code received: " + response.statusCode(), response);
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;
        final Headers _headers;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            this.sdkConfiguration = sdkConfiguration;
            this._headers = _headers;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_get_connector_meta", Optional.empty(), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_get_connector_meta", Optional.empty(), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_get_connector_meta", Optional.empty(), this.securitySource());
        }

        <T> HttpRequest buildRequest(T request, Class<T> klass) throws Exception {
            String url = Utils.generateURL(klass, this.baseUrl, "/connectors/meta/{provider}", request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            this._headers.forEach((k, list) -> list.forEach(v -> req.addHeader((String)k, (String)v)));
            req.addQueryParams(Utils.getQueryParams(klass, request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

