/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.ResponseWithBody;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public interface HTTPClient {
    public static final HttpClient client = HttpClient.newHttpClient();

    default public HttpResponse<InputStream> send(HttpRequest request) throws IOException, InterruptedException, URISyntaxException {
        return client.send(request, HttpResponse.BodyHandlers.ofInputStream());
    }

    default public CompletableFuture<HttpResponse<Blob>> sendAsync(HttpRequest request) {
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofPublisher()).thenApply(resp -> new ResponseWithBody(resp, Blob::from));
    }

    default public void enableDebugLogging(boolean enabled) {
    }

    default public boolean isDebugLoggingEnabled() {
        return false;
    }
}

