/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class Document {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The category of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category")
    private JsonNullable<? extends WorkEligibilityCategory> category;

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("contents")
    @Deprecated
    private JsonNullable<? extends List<Content>> contents;

    /**
     * The categoryId of the documents
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category_id")
    private JsonNullable<String> categoryId;

    /**
     * The creation date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The update date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * URL where the file content is located
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_url")
    private JsonNullable<String> remoteUrl;

    /**
     * The file format of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends WorkEligibilityFileFormat> fileFormat;

    @JsonCreator
    public Document(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("category") JsonNullable<? extends WorkEligibilityCategory> category,
            @JsonProperty("contents") JsonNullable<? extends List<Content>> contents,
            @JsonProperty("category_id") JsonNullable<String> categoryId,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("remote_url") JsonNullable<String> remoteUrl,
            @JsonProperty("file_format") JsonNullable<? extends WorkEligibilityFileFormat> fileFormat) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(category, "category");
        Utils.checkNotNull(contents, "contents");
        Utils.checkNotNull(categoryId, "categoryId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.category = category;
        this.contents = contents;
        this.categoryId = categoryId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.remoteUrl = remoteUrl;
        this.fileFormat = fileFormat;
    }
    
    public Document() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name of the file
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The category of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkEligibilityCategory> category() {
        return (JsonNullable<WorkEligibilityCategory>) category;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Content>> contents() {
        return (JsonNullable<List<Content>>) contents;
    }

    /**
     * The categoryId of the documents
     */
    @JsonIgnore
    public JsonNullable<String> categoryId() {
        return categoryId;
    }

    /**
     * The creation date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The update date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * URL where the file content is located
     */
    @JsonIgnore
    public JsonNullable<String> remoteUrl() {
        return remoteUrl;
    }

    /**
     * The file format of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkEligibilityFileFormat> fileFormat() {
        return (JsonNullable<WorkEligibilityFileFormat>) fileFormat;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Document withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Document withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Document withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Document withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name of the file
     */
    public Document withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the file
     */
    public Document withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The category of the file
     */
    public Document withCategory(WorkEligibilityCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = JsonNullable.of(category);
        return this;
    }

    /**
     * The category of the file
     */
    public Document withCategory(JsonNullable<? extends WorkEligibilityCategory> category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Document withContents(List<Content> contents) {
        Utils.checkNotNull(contents, "contents");
        this.contents = JsonNullable.of(contents);
        return this;
    }

    /**
     * The content of the file. Deprecated, use `url` and `file_format` one level up instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Document withContents(JsonNullable<? extends List<Content>> contents) {
        Utils.checkNotNull(contents, "contents");
        this.contents = contents;
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public Document withCategoryId(String categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = JsonNullable.of(categoryId);
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public Document withCategoryId(JsonNullable<String> categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = categoryId;
        return this;
    }

    /**
     * The creation date of the file
     */
    public Document withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The creation date of the file
     */
    public Document withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The update date of the file
     */
    public Document withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The update date of the file
     */
    public Document withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * URL where the file content is located
     */
    public Document withRemoteUrl(String remoteUrl) {
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        this.remoteUrl = JsonNullable.of(remoteUrl);
        return this;
    }

    /**
     * URL where the file content is located
     */
    public Document withRemoteUrl(JsonNullable<String> remoteUrl) {
        Utils.checkNotNull(remoteUrl, "remoteUrl");
        this.remoteUrl = remoteUrl;
        return this;
    }

    /**
     * The file format of the file
     */
    public Document withFileFormat(WorkEligibilityFileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The file format of the file
     */
    public Document withFileFormat(JsonNullable<? extends WorkEligibilityFileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Document other = (Document) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.category, other.category) &&
            Utils.enhancedDeepEquals(this.contents, other.contents) &&
            Utils.enhancedDeepEquals(this.categoryId, other.categoryId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.remoteUrl, other.remoteUrl) &&
            Utils.enhancedDeepEquals(this.fileFormat, other.fileFormat);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            category, contents, categoryId,
            createdAt, updatedAt, remoteUrl,
            fileFormat);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Document.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "category", category,
                "contents", contents,
                "categoryId", categoryId,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "remoteUrl", remoteUrl,
                "fileFormat", fileFormat);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<? extends WorkEligibilityCategory> category = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends List<Content>> contents = JsonNullable.undefined();

        private JsonNullable<String> categoryId = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<String> remoteUrl = JsonNullable.undefined();

        private JsonNullable<? extends WorkEligibilityFileFormat> fileFormat = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The name of the file
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the file
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The category of the file
         */
        public Builder category(WorkEligibilityCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = JsonNullable.of(category);
            return this;
        }

        /**
         * The category of the file
         */
        public Builder category(JsonNullable<? extends WorkEligibilityCategory> category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }


        /**
         * The content of the file. Deprecated, use `url` and `file_format` one level up instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contents(List<Content> contents) {
            Utils.checkNotNull(contents, "contents");
            this.contents = JsonNullable.of(contents);
            return this;
        }

        /**
         * The content of the file. Deprecated, use `url` and `file_format` one level up instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contents(JsonNullable<? extends List<Content>> contents) {
            Utils.checkNotNull(contents, "contents");
            this.contents = contents;
            return this;
        }


        /**
         * The categoryId of the documents
         */
        public Builder categoryId(String categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = JsonNullable.of(categoryId);
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(JsonNullable<String> categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = categoryId;
            return this;
        }


        /**
         * The creation date of the file
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The creation date of the file
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The update date of the file
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The update date of the file
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * URL where the file content is located
         */
        public Builder remoteUrl(String remoteUrl) {
            Utils.checkNotNull(remoteUrl, "remoteUrl");
            this.remoteUrl = JsonNullable.of(remoteUrl);
            return this;
        }

        /**
         * URL where the file content is located
         */
        public Builder remoteUrl(JsonNullable<String> remoteUrl) {
            Utils.checkNotNull(remoteUrl, "remoteUrl");
            this.remoteUrl = remoteUrl;
            return this;
        }


        /**
         * The file format of the file
         */
        public Builder fileFormat(WorkEligibilityFileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(JsonNullable<? extends WorkEligibilityFileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }

        public Document build() {

            return new Document(
                id, remoteId, name,
                category, contents, categoryId,
                createdAt, updatedAt, remoteUrl,
                fileFormat);
        }

    }
}
