/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsUpdateNotesRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUpdateInterviewNoteRequest;
import com.stackone.stackone_client_java.operations.AtsUpdateInterviewNote;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsUpdateInterviewNoteRequestBuilder {

    private String xAccountId;
    private String id;
    private String subResourceId;
    private AtsUpdateNotesRequestDto atsUpdateNotesRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public AtsUpdateInterviewNoteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUpdateInterviewNoteRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateInterviewNoteRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateInterviewNoteRequestBuilder subResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public AtsUpdateInterviewNoteRequestBuilder atsUpdateNotesRequestDto(AtsUpdateNotesRequestDto atsUpdateNotesRequestDto) {
        Utils.checkNotNull(atsUpdateNotesRequestDto, "atsUpdateNotesRequestDto");
        this.atsUpdateNotesRequestDto = atsUpdateNotesRequestDto;
        return this;
    }
                
    public AtsUpdateInterviewNoteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUpdateInterviewNoteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private AtsUpdateInterviewNoteRequest buildRequest() {

        AtsUpdateInterviewNoteRequest request = new AtsUpdateInterviewNoteRequest(xAccountId,
            id,
            subResourceId,
            atsUpdateNotesRequestDto);

        return request;
    }

    public CompletableFuture<AtsUpdateInterviewNoteResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsUpdateInterviewNoteRequest, AtsUpdateInterviewNoteResponse> operation
              = new AtsUpdateInterviewNote.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        AtsUpdateInterviewNoteRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
