/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ATSLocationsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListLocationsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ATSLocationsPaginated> atsLocationsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListLocationsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ATSLocationsPaginated> atsLocationsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsLocationsPaginated = atsLocationsPaginated;
        this.headers = headers;
    }

    public AtsListLocationsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ATSLocationsPaginated> atsLocationsPaginated() {
        return this.atsLocationsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListLocationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListLocationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListLocationsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListLocationsResponse withATSLocationsPaginated(ATSLocationsPaginated atsLocationsPaginated) {
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        this.atsLocationsPaginated = Optional.ofNullable(atsLocationsPaginated);
        return this;
    }

    public AtsListLocationsResponse withATSLocationsPaginated(Optional<? extends ATSLocationsPaginated> atsLocationsPaginated) {
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        this.atsLocationsPaginated = atsLocationsPaginated;
        return this;
    }

    public AtsListLocationsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListLocationsResponse other = (AtsListLocationsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.atsLocationsPaginated, other.atsLocationsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.atsLocationsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListLocationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsLocationsPaginated", this.atsLocationsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ATSLocationsPaginated> atsLocationsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsLocationsPaginated(ATSLocationsPaginated atsLocationsPaginated) {
            Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
            this.atsLocationsPaginated = Optional.ofNullable(atsLocationsPaginated);
            return this;
        }

        public Builder atsLocationsPaginated(Optional<? extends ATSLocationsPaginated> atsLocationsPaginated) {
            Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
            this.atsLocationsPaginated = atsLocationsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListLocationsResponse build() {
            return new AtsListLocationsResponse(this.contentType, this.statusCode, this.rawResponse, this.atsLocationsPaginated, this.headers);
        }
    }
}

