/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.IamUpdateUserRequestDto;
import com.stackone.stackone_client_java.models.operations.IamDeleteUserRequest;
import com.stackone.stackone_client_java.models.operations.IamGetGroupRequest;
import com.stackone.stackone_client_java.models.operations.IamGetPolicyRequest;
import com.stackone.stackone_client_java.models.operations.IamGetRoleRequest;
import com.stackone.stackone_client_java.models.operations.IamGetUserRequest;
import com.stackone.stackone_client_java.models.operations.IamListGroupsRequest;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesRequest;
import com.stackone.stackone_client_java.models.operations.IamListRolesRequest;
import com.stackone.stackone_client_java.models.operations.IamListUsersRequest;
import com.stackone.stackone_client_java.models.operations.IamUpdateUserRequest;
import com.stackone.stackone_client_java.models.operations.async.IamDeleteUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamDeleteUserResponse;
import com.stackone.stackone_client_java.models.operations.async.IamGetGroupRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamGetGroupResponse;
import com.stackone.stackone_client_java.models.operations.async.IamGetPolicyRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamGetPolicyResponse;
import com.stackone.stackone_client_java.models.operations.async.IamGetRoleRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamGetRoleResponse;
import com.stackone.stackone_client_java.models.operations.async.IamGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamGetUserResponse;
import com.stackone.stackone_client_java.models.operations.async.IamListGroupsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamListGroupsResponse;
import com.stackone.stackone_client_java.models.operations.async.IamListPoliciesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamListPoliciesResponse;
import com.stackone.stackone_client_java.models.operations.async.IamListRolesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamListRolesResponse;
import com.stackone.stackone_client_java.models.operations.async.IamListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamListUsersResponse;
import com.stackone.stackone_client_java.models.operations.async.IamUpdateUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.IamUpdateUserResponse;
import com.stackone.stackone_client_java.operations.IamDeleteUser;
import com.stackone.stackone_client_java.operations.IamGetGroup;
import com.stackone.stackone_client_java.operations.IamGetPolicy;
import com.stackone.stackone_client_java.operations.IamGetRole;
import com.stackone.stackone_client_java.operations.IamGetUser;
import com.stackone.stackone_client_java.operations.IamListGroups;
import com.stackone.stackone_client_java.operations.IamListPolicies;
import com.stackone.stackone_client_java.operations.IamListRoles;
import com.stackone.stackone_client_java.operations.IamListUsers;
import com.stackone.stackone_client_java.operations.IamUpdateUser;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncIam {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Iam syncSDK;

    AsyncIam(Iam syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Iam sync() {
        return syncSDK;
    }


    /**
     * List Users
     * 
     * @return The async call builder
     */
    public IamListUsersRequestBuilder listUsers() {
        return new IamListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamListUsersResponse>} - The async response
     */
    public CompletableFuture<IamListUsersResponse> listUsers(IamListUsersRequest request) {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamListUsersResponse>} - The async response
     */
    public CompletableFuture<IamListUsersResponse> listUsers(IamListUsersRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamListUsersRequest, IamListUsersResponse> operation
              = new IamListUsers.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User
     * 
     * @return The async call builder
     */
    public IamGetUserRequestBuilder getUser() {
        return new IamGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamGetUserResponse>} - The async response
     */
    public CompletableFuture<IamGetUserResponse> getUser(IamGetUserRequest request) {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamGetUserResponse>} - The async response
     */
    public CompletableFuture<IamGetUserResponse> getUser(IamGetUserRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamGetUserRequest, IamGetUserResponse> operation
              = new IamGetUser.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete User
     * 
     * @return The async call builder
     */
    public IamDeleteUserRequestBuilder deleteUser() {
        return new IamDeleteUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete User
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @return {@code CompletableFuture<IamDeleteUserResponse>} - The async response
     */
    public CompletableFuture<IamDeleteUserResponse> deleteUser(String xAccountId, String id) {
        return deleteUser(xAccountId, id, Optional.empty());
    }

    /**
     * Delete User
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param options additional options
     * @return {@code CompletableFuture<IamDeleteUserResponse>} - The async response
     */
    public CompletableFuture<IamDeleteUserResponse> deleteUser(
            String xAccountId, String id,
            Optional<Options> options) {
        IamDeleteUserRequest request =
            IamDeleteUserRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .build();
        AsyncRequestOperation<IamDeleteUserRequest, IamDeleteUserResponse> operation
              = new IamDeleteUser.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Update User
     * 
     * @return The async call builder
     */
    public IamUpdateUserRequestBuilder updateUser() {
        return new IamUpdateUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Update User
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param iamUpdateUserRequestDto 
     * @return {@code CompletableFuture<IamUpdateUserResponse>} - The async response
     */
    public CompletableFuture<IamUpdateUserResponse> updateUser(
            String xAccountId, String id,
            IamUpdateUserRequestDto iamUpdateUserRequestDto) {
        return updateUser(
                xAccountId, id, iamUpdateUserRequestDto,
                Optional.empty());
    }

    /**
     * Update User
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param iamUpdateUserRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<IamUpdateUserResponse>} - The async response
     */
    public CompletableFuture<IamUpdateUserResponse> updateUser(
            String xAccountId, String id,
            IamUpdateUserRequestDto iamUpdateUserRequestDto, Optional<Options> options) {
        IamUpdateUserRequest request =
            IamUpdateUserRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .iamUpdateUserRequestDto(iamUpdateUserRequestDto)
                .build();
        AsyncRequestOperation<IamUpdateUserRequest, IamUpdateUserResponse> operation
              = new IamUpdateUser.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Roles
     * 
     * @return The async call builder
     */
    public IamListRolesRequestBuilder listRoles() {
        return new IamListRolesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Roles
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamListRolesResponse>} - The async response
     */
    public CompletableFuture<IamListRolesResponse> listRoles(IamListRolesRequest request) {
        return listRoles(request, Optional.empty());
    }

    /**
     * List Roles
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamListRolesResponse>} - The async response
     */
    public CompletableFuture<IamListRolesResponse> listRoles(IamListRolesRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamListRolesRequest, IamListRolesResponse> operation
              = new IamListRoles.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Role
     * 
     * @return The async call builder
     */
    public IamGetRoleRequestBuilder getRole() {
        return new IamGetRoleRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Role
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamGetRoleResponse>} - The async response
     */
    public CompletableFuture<IamGetRoleResponse> getRole(IamGetRoleRequest request) {
        return getRole(request, Optional.empty());
    }

    /**
     * Get Role
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamGetRoleResponse>} - The async response
     */
    public CompletableFuture<IamGetRoleResponse> getRole(IamGetRoleRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamGetRoleRequest, IamGetRoleResponse> operation
              = new IamGetRole.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Groups
     * 
     * @return The async call builder
     */
    public IamListGroupsRequestBuilder listGroups() {
        return new IamListGroupsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Groups
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamListGroupsResponse>} - The async response
     */
    public CompletableFuture<IamListGroupsResponse> listGroups(IamListGroupsRequest request) {
        return listGroups(request, Optional.empty());
    }

    /**
     * List Groups
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamListGroupsResponse>} - The async response
     */
    public CompletableFuture<IamListGroupsResponse> listGroups(IamListGroupsRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamListGroupsRequest, IamListGroupsResponse> operation
              = new IamListGroups.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Group
     * 
     * @return The async call builder
     */
    public IamGetGroupRequestBuilder getGroup() {
        return new IamGetGroupRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Group
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamGetGroupResponse>} - The async response
     */
    public CompletableFuture<IamGetGroupResponse> getGroup(IamGetGroupRequest request) {
        return getGroup(request, Optional.empty());
    }

    /**
     * Get Group
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamGetGroupResponse>} - The async response
     */
    public CompletableFuture<IamGetGroupResponse> getGroup(IamGetGroupRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamGetGroupRequest, IamGetGroupResponse> operation
              = new IamGetGroup.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Policies
     * 
     * @return The async call builder
     */
    public IamListPoliciesRequestBuilder listPolicies() {
        return new IamListPoliciesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Policies
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamListPoliciesResponse>} - The async response
     */
    public CompletableFuture<IamListPoliciesResponse> listPolicies(IamListPoliciesRequest request) {
        return listPolicies(request, Optional.empty());
    }

    /**
     * List Policies
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamListPoliciesResponse>} - The async response
     */
    public CompletableFuture<IamListPoliciesResponse> listPolicies(IamListPoliciesRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamListPoliciesRequest, IamListPoliciesResponse> operation
              = new IamListPolicies.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Policy
     * 
     * @return The async call builder
     */
    public IamGetPolicyRequestBuilder getPolicy() {
        return new IamGetPolicyRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Policy
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<IamGetPolicyResponse>} - The async response
     */
    public CompletableFuture<IamGetPolicyResponse> getPolicy(IamGetPolicyRequest request) {
        return getPolicy(request, Optional.empty());
    }

    /**
     * Get Policy
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<IamGetPolicyResponse>} - The async response
     */
    public CompletableFuture<IamGetPolicyResponse> getPolicy(IamGetPolicyRequest request, Optional<Options> options) {
        AsyncRequestOperation<IamGetPolicyRequest, IamGetPolicyResponse> operation
              = new IamGetPolicy.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
