/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * SkillsValue
 * 
 * <p>The unified skill level. For write operations: provide one of the listed enum values, or omit/set to
 * "unmapped_value" to use source_value instead.
 */
@JsonDeserialize(using = SkillsValue._Deserializer.class)
@JsonSerialize(using = SkillsValue._Serializer.class)
public class SkillsValue {

    public static final SkillsValue PRIMARY = new SkillsValue("primary");
    public static final SkillsValue SECONDARY = new SkillsValue("secondary");
    public static final SkillsValue TERTIARY = new SkillsValue("tertiary");
    public static final SkillsValue UNMAPPED_VALUE = new SkillsValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, SkillsValue> values = createValuesMap();
    private static final Map<String, SkillsValueEnum> enums = createEnumsMap();

    private final String value;

    private SkillsValue(String value) {
        this.value = value;
    }

    /**
     * Returns a SkillsValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as SkillsValue
     */ 
    public static SkillsValue of(String value) {
        synchronized (SkillsValue.class) {
            return values.computeIfAbsent(value, v -> new SkillsValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<SkillsValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SkillsValue other = (SkillsValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "SkillsValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static SkillsValue[] values() {
        synchronized (SkillsValue.class) {
            return values.values().toArray(new SkillsValue[] {});
        }
    }

    private static final Map<String, SkillsValue> createValuesMap() {
        Map<String, SkillsValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsValueEnum> createEnumsMap() {
        Map<String, SkillsValueEnum> map = new HashMap<>();
        map.put("primary", SkillsValueEnum.PRIMARY);
        map.put("secondary", SkillsValueEnum.SECONDARY);
        map.put("tertiary", SkillsValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<SkillsValue> {

        protected _Serializer() {
            super(SkillsValue.class);
        }

        @Override
        public void serialize(SkillsValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<SkillsValue> {

        protected _Deserializer() {
            super(SkillsValue.class);
        }

        @Override
        public SkillsValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return SkillsValue.of(v);
        }
    }
    
    public enum SkillsValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private SkillsValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

