/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class StackoneMcpDeleteRequest {
    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private Optional<String> xAccountId;

    /**
     * Account secure id (alternative to x-account-id header)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=x-account-id")
    private Optional<? extends Object> xAccountIdQueryParameter;

    /**
     * Session id
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=mcp-session-id")
    private String mcpSessionId;

    @JsonCreator
    public StackoneMcpDeleteRequest(
            Optional<String> xAccountId,
            Optional<? extends Object> xAccountIdQueryParameter,
            String mcpSessionId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.xAccountId = xAccountId;
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        this.mcpSessionId = mcpSessionId;
    }
    
    public StackoneMcpDeleteRequest(
            String mcpSessionId) {
        this(Optional.empty(), Optional.empty(), mcpSessionId);
    }

    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    @JsonIgnore
    public Optional<String> xAccountId() {
        return xAccountId;
    }

    /**
     * Account secure id (alternative to x-account-id header)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Object> xAccountIdQueryParameter() {
        return (Optional<Object>) xAccountIdQueryParameter;
    }

    /**
     * Session id
     */
    @JsonIgnore
    public String mcpSessionId() {
        return mcpSessionId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    public StackoneMcpDeleteRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = Optional.ofNullable(xAccountId);
        return this;
    }


    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    public StackoneMcpDeleteRequest withXAccountId(Optional<String> xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Account secure id (alternative to x-account-id header)
     */
    public StackoneMcpDeleteRequest withXAccountIdQueryParameter(Object xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
        return this;
    }


    /**
     * Account secure id (alternative to x-account-id header)
     */
    public StackoneMcpDeleteRequest withXAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        return this;
    }

    /**
     * Session id
     */
    public StackoneMcpDeleteRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpDeleteRequest other = (StackoneMcpDeleteRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xAccountIdQueryParameter, other.xAccountIdQueryParameter) &&
            Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xAccountIdQueryParameter, mcpSessionId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneMcpDeleteRequest.class,
                "xAccountId", xAccountId,
                "xAccountIdQueryParameter", xAccountIdQueryParameter,
                "mcpSessionId", mcpSessionId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> xAccountId = Optional.empty();

        private Optional<? extends Object> xAccountIdQueryParameter = Optional.empty();

        private String mcpSessionId;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Account secure id for the target provider account (optional if x-account-id query parameter is
         * provided)
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = Optional.ofNullable(xAccountId);
            return this;
        }

        /**
         * Account secure id for the target provider account (optional if x-account-id query parameter is
         * provided)
         */
        public Builder xAccountId(Optional<String> xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Account secure id (alternative to x-account-id header)
         */
        public Builder xAccountIdQueryParameter(Object xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
            return this;
        }

        /**
         * Account secure id (alternative to x-account-id header)
         */
        public Builder xAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = xAccountIdQueryParameter;
            return this;
        }


        /**
         * Session id
         */
        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public StackoneMcpDeleteRequest build() {

            return new StackoneMcpDeleteRequest(
                xAccountId, xAccountIdQueryParameter, mcpSessionId);
        }

    }
}
