/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.ActionBuildDto;
import com.stackone.stackone_client_java.models.components.ActionSearchDto;
import com.stackone.stackone_client_java.models.components.ActionsRpcRequestDto;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneBuildActionEmbeddingsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneBuildActionEmbeddingsResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListActionsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListActionsMetaResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneRpcActionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneRpcActionResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneSearchActionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneSearchActionsResponse;
import com.stackone.stackone_client_java.operations.StackoneBuildActionEmbeddings;
import com.stackone.stackone_client_java.operations.StackoneListActionsMeta;
import com.stackone.stackone_client_java.operations.StackoneRpcAction;
import com.stackone.stackone_client_java.operations.StackoneSearchActions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Retrieve Actions metadata and definitions.
 */
public class AsyncActions {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Actions syncSDK;

    AsyncActions(Actions syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Actions sync() {
        return syncSDK;
    }


    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @return The async call builder
     */
    public StackoneListActionsMetaRequestBuilder listActionsMeta() {
        return new StackoneListActionsMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneListActionsMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneListActionsMetaResponse> listActionsMeta(StackoneListActionsMetaRequest request) {
        return listActionsMeta(request, Optional.empty());
    }

    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneListActionsMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneListActionsMetaResponse> listActionsMeta(StackoneListActionsMetaRequest request, Optional<Options> options) {
        AsyncRequestOperation<StackoneListActionsMetaRequest, StackoneListActionsMetaResponse> operation
              = new StackoneListActionsMeta.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Search connector actions by semantic similarity
     * 
     * @return The async call builder
     */
    public StackoneSearchActionsRequestBuilder searchActions() {
        return new StackoneSearchActionsRequestBuilder(sdkConfiguration);
    }

    /**
     * Search connector actions by semantic similarity
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneSearchActionsResponse>} - The async response
     */
    public CompletableFuture<StackoneSearchActionsResponse> searchActions(ActionSearchDto request) {
        return searchActions(request, Optional.empty());
    }

    /**
     * Search connector actions by semantic similarity
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneSearchActionsResponse>} - The async response
     */
    public CompletableFuture<StackoneSearchActionsResponse> searchActions(ActionSearchDto request, Optional<Options> options) {
        AsyncRequestOperation<ActionSearchDto, StackoneSearchActionsResponse> operation
              = new StackoneSearchActions.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Rebuild action embeddings for semantic search
     * 
     * @return The async call builder
     */
    public StackoneBuildActionEmbeddingsRequestBuilder buildActionEmbeddings() {
        return new StackoneBuildActionEmbeddingsRequestBuilder(sdkConfiguration);
    }

    /**
     * Rebuild action embeddings for semantic search
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneBuildActionEmbeddingsResponse>} - The async response
     */
    public CompletableFuture<StackoneBuildActionEmbeddingsResponse> buildActionEmbeddings(ActionBuildDto request) {
        return buildActionEmbeddings(request, Optional.empty());
    }

    /**
     * Rebuild action embeddings for semantic search
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneBuildActionEmbeddingsResponse>} - The async response
     */
    public CompletableFuture<StackoneBuildActionEmbeddingsResponse> buildActionEmbeddings(ActionBuildDto request, Optional<Options> options) {
        AsyncRequestOperation<ActionBuildDto, StackoneBuildActionEmbeddingsResponse> operation
              = new StackoneBuildActionEmbeddings.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @return The async call builder
     */
    public StackoneRpcActionRequestBuilder rpcAction() {
        return new StackoneRpcActionRequestBuilder(sdkConfiguration);
    }

    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<StackoneRpcActionResponse>} - The async response
     */
    public CompletableFuture<StackoneRpcActionResponse> rpcAction(ActionsRpcRequestDto request) {
        return rpcAction(request, Optional.empty());
    }

    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<StackoneRpcActionResponse>} - The async response
     */
    public CompletableFuture<StackoneRpcActionResponse> rpcAction(ActionsRpcRequestDto request, Optional<Options> options) {
        AsyncRequestOperation<ActionsRpcRequestDto, StackoneRpcActionResponse> operation
              = new StackoneRpcAction.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
