/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;


public class ActionSearchResultDto {
    /**
     * Unique action identifier
     */
    @JsonProperty("action_name")
    private String actionName;

    /**
     * Connector key
     */
    @JsonProperty("connector_key")
    private String connectorKey;

    /**
     * Cosine similarity score (0-1)
     */
    @JsonProperty("similarity_score")
    private double similarityScore;

    /**
     * Human-readable action label
     */
    @JsonProperty("label")
    private String label;

    /**
     * Action description
     */
    @JsonProperty("description")
    private String description;

    /**
     * Project ID of the action (global for shared actions)
     */
    @JsonProperty("project_id")
    private String projectId;

    @JsonCreator
    public ActionSearchResultDto(
            @JsonProperty("action_name") String actionName,
            @JsonProperty("connector_key") String connectorKey,
            @JsonProperty("similarity_score") double similarityScore,
            @JsonProperty("label") String label,
            @JsonProperty("description") String description,
            @JsonProperty("project_id") String projectId) {
        Utils.checkNotNull(actionName, "actionName");
        Utils.checkNotNull(connectorKey, "connectorKey");
        Utils.checkNotNull(similarityScore, "similarityScore");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(projectId, "projectId");
        this.actionName = actionName;
        this.connectorKey = connectorKey;
        this.similarityScore = similarityScore;
        this.label = label;
        this.description = description;
        this.projectId = projectId;
    }

    /**
     * Unique action identifier
     */
    @JsonIgnore
    public String actionName() {
        return actionName;
    }

    /**
     * Connector key
     */
    @JsonIgnore
    public String connectorKey() {
        return connectorKey;
    }

    /**
     * Cosine similarity score (0-1)
     */
    @JsonIgnore
    public double similarityScore() {
        return similarityScore;
    }

    /**
     * Human-readable action label
     */
    @JsonIgnore
    public String label() {
        return label;
    }

    /**
     * Action description
     */
    @JsonIgnore
    public String description() {
        return description;
    }

    /**
     * Project ID of the action (global for shared actions)
     */
    @JsonIgnore
    public String projectId() {
        return projectId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique action identifier
     */
    public ActionSearchResultDto withActionName(String actionName) {
        Utils.checkNotNull(actionName, "actionName");
        this.actionName = actionName;
        return this;
    }

    /**
     * Connector key
     */
    public ActionSearchResultDto withConnectorKey(String connectorKey) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        this.connectorKey = connectorKey;
        return this;
    }

    /**
     * Cosine similarity score (0-1)
     */
    public ActionSearchResultDto withSimilarityScore(double similarityScore) {
        Utils.checkNotNull(similarityScore, "similarityScore");
        this.similarityScore = similarityScore;
        return this;
    }

    /**
     * Human-readable action label
     */
    public ActionSearchResultDto withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * Action description
     */
    public ActionSearchResultDto withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Project ID of the action (global for shared actions)
     */
    public ActionSearchResultDto withProjectId(String projectId) {
        Utils.checkNotNull(projectId, "projectId");
        this.projectId = projectId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionSearchResultDto other = (ActionSearchResultDto) o;
        return 
            Utils.enhancedDeepEquals(this.actionName, other.actionName) &&
            Utils.enhancedDeepEquals(this.connectorKey, other.connectorKey) &&
            Utils.enhancedDeepEquals(this.similarityScore, other.similarityScore) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.projectId, other.projectId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            actionName, connectorKey, similarityScore,
            label, description, projectId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionSearchResultDto.class,
                "actionName", actionName,
                "connectorKey", connectorKey,
                "similarityScore", similarityScore,
                "label", label,
                "description", description,
                "projectId", projectId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String actionName;

        private String connectorKey;

        private Double similarityScore;

        private String label;

        private String description;

        private String projectId;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique action identifier
         */
        public Builder actionName(String actionName) {
            Utils.checkNotNull(actionName, "actionName");
            this.actionName = actionName;
            return this;
        }


        /**
         * Connector key
         */
        public Builder connectorKey(String connectorKey) {
            Utils.checkNotNull(connectorKey, "connectorKey");
            this.connectorKey = connectorKey;
            return this;
        }


        /**
         * Cosine similarity score (0-1)
         */
        public Builder similarityScore(double similarityScore) {
            Utils.checkNotNull(similarityScore, "similarityScore");
            this.similarityScore = similarityScore;
            return this;
        }


        /**
         * Human-readable action label
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }


        /**
         * Action description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Project ID of the action (global for shared actions)
         */
        public Builder projectId(String projectId) {
            Utils.checkNotNull(projectId, "projectId");
            this.projectId = projectId;
            return this;
        }

        public ActionSearchResultDto build() {

            return new ActionSearchResultDto(
                actionName, connectorKey, similarityScore,
                label, description, projectId);
        }

    }
}
