/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AssignmentResultValue
 * 
 * <p>The StackOne unified result status.
 */
public class AssignmentResultValue {

    public static final AssignmentResultValue PASS = new AssignmentResultValue("Pass");
    public static final AssignmentResultValue FAIL = new AssignmentResultValue("Fail");
    public static final AssignmentResultValue UNMAPPED_VALUE = new AssignmentResultValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssignmentResultValue> values = createValuesMap();
    private static final Map<String, AssignmentResultValueEnum> enums = createEnumsMap();

    private final String value;

    private AssignmentResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssignmentResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssignmentResultValue
     */ 
    @JsonCreator
    public static AssignmentResultValue of(String value) {
        synchronized (AssignmentResultValue.class) {
            return values.computeIfAbsent(value, v -> new AssignmentResultValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AssignmentResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssignmentResultValue other = (AssignmentResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssignmentResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssignmentResultValue[] values() {
        synchronized (AssignmentResultValue.class) {
            return values.values().toArray(new AssignmentResultValue[] {});
        }
    }

    private static final Map<String, AssignmentResultValue> createValuesMap() {
        Map<String, AssignmentResultValue> map = new LinkedHashMap<>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentResultValueEnum> createEnumsMap() {
        Map<String, AssignmentResultValueEnum> map = new HashMap<>();
        map.put("Pass", AssignmentResultValueEnum.PASS);
        map.put("Fail", AssignmentResultValueEnum.FAIL);
        map.put("unmapped_value", AssignmentResultValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AssignmentResultValueEnum {

        PASS("Pass"),
        FAIL("Fail"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AssignmentResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

