/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AttachmentValue
 * 
 * <p>The content type of the attachment.
 */
public class AttachmentValue {

    public static final AttachmentValue TEXT = new AttachmentValue("text");
    public static final AttachmentValue PDF = new AttachmentValue("pdf");
    public static final AttachmentValue VIDEO = new AttachmentValue("video");
    public static final AttachmentValue OTHER = new AttachmentValue("other");
    public static final AttachmentValue UNMAPPED_VALUE = new AttachmentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AttachmentValue> values = createValuesMap();
    private static final Map<String, AttachmentValueEnum> enums = createEnumsMap();

    private final String value;

    private AttachmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AttachmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AttachmentValue
     */ 
    @JsonCreator
    public static AttachmentValue of(String value) {
        synchronized (AttachmentValue.class) {
            return values.computeIfAbsent(value, v -> new AttachmentValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AttachmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AttachmentValue other = (AttachmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AttachmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AttachmentValue[] values() {
        synchronized (AttachmentValue.class) {
            return values.values().toArray(new AttachmentValue[] {});
        }
    }

    private static final Map<String, AttachmentValue> createValuesMap() {
        Map<String, AttachmentValue> map = new LinkedHashMap<>();
        map.put("text", TEXT);
        map.put("pdf", PDF);
        map.put("video", VIDEO);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AttachmentValueEnum> createEnumsMap() {
        Map<String, AttachmentValueEnum> map = new HashMap<>();
        map.put("text", AttachmentValueEnum.TEXT);
        map.put("pdf", AttachmentValueEnum.PDF);
        map.put("video", AttachmentValueEnum.VIDEO);
        map.put("other", AttachmentValueEnum.OTHER);
        map.put("unmapped_value", AttachmentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AttachmentValueEnum {

        TEXT("text"),
        PDF("pdf"),
        VIDEO("video"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AttachmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

