/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CompletionValue
 * 
 * <p>The StackOne unified result status.
 */
public class CompletionValue {

    public static final CompletionValue PASS = new CompletionValue("Pass");
    public static final CompletionValue FAIL = new CompletionValue("Fail");
    public static final CompletionValue UNMAPPED_VALUE = new CompletionValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CompletionValue> values = createValuesMap();
    private static final Map<String, CompletionValueEnum> enums = createEnumsMap();

    private final String value;

    private CompletionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CompletionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CompletionValue
     */ 
    @JsonCreator
    public static CompletionValue of(String value) {
        synchronized (CompletionValue.class) {
            return values.computeIfAbsent(value, v -> new CompletionValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CompletionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CompletionValue other = (CompletionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CompletionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CompletionValue[] values() {
        synchronized (CompletionValue.class) {
            return values.values().toArray(new CompletionValue[] {});
        }
    }

    private static final Map<String, CompletionValue> createValuesMap() {
        Map<String, CompletionValue> map = new LinkedHashMap<>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CompletionValueEnum> createEnumsMap() {
        Map<String, CompletionValueEnum> map = new HashMap<>();
        map.put("Pass", CompletionValueEnum.PASS);
        map.put("Fail", CompletionValueEnum.FAIL);
        map.put("unmapped_value", CompletionValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CompletionValueEnum {

        PASS("Pass"),
        FAIL("Fail"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CompletionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

