/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * FieldType
 * 
 * <p>The type of the field
 */
public class FieldType {

    public static final FieldType SHORT_TEXT = new FieldType("short_text");
    public static final FieldType LONG_TEXT = new FieldType("long_text");
    public static final FieldType MULTI_SELECT = new FieldType("multi_select");
    public static final FieldType SINGLE_SELECT = new FieldType("single_select");
    public static final FieldType BOOLEAN = new FieldType("boolean");
    public static final FieldType NUMBER = new FieldType("number");
    public static final FieldType DATE = new FieldType("date");
    public static final FieldType PHONE = new FieldType("phone");
    public static final FieldType EMAIL = new FieldType("email");
    public static final FieldType SCORE = new FieldType("score");
    public static final FieldType LOCATION = new FieldType("location");
    public static final FieldType UNMAPPED_VALUE = new FieldType("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, FieldType> values = createValuesMap();
    private static final Map<String, FieldTypeEnum> enums = createEnumsMap();

    private final String value;

    private FieldType(String value) {
        this.value = value;
    }

    /**
     * Returns a FieldType with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as FieldType
     */ 
    @JsonCreator
    public static FieldType of(String value) {
        synchronized (FieldType.class) {
            return values.computeIfAbsent(value, v -> new FieldType(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<FieldTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        FieldType other = (FieldType) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "FieldType [value=" + value + "]";
    }

    // return an array just like an enum
    public static FieldType[] values() {
        synchronized (FieldType.class) {
            return values.values().toArray(new FieldType[] {});
        }
    }

    private static final Map<String, FieldType> createValuesMap() {
        Map<String, FieldType> map = new LinkedHashMap<>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("phone", PHONE);
        map.put("email", EMAIL);
        map.put("score", SCORE);
        map.put("location", LOCATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, FieldTypeEnum> createEnumsMap() {
        Map<String, FieldTypeEnum> map = new HashMap<>();
        map.put("short_text", FieldTypeEnum.SHORT_TEXT);
        map.put("long_text", FieldTypeEnum.LONG_TEXT);
        map.put("multi_select", FieldTypeEnum.MULTI_SELECT);
        map.put("single_select", FieldTypeEnum.SINGLE_SELECT);
        map.put("boolean", FieldTypeEnum.BOOLEAN);
        map.put("number", FieldTypeEnum.NUMBER);
        map.put("date", FieldTypeEnum.DATE);
        map.put("phone", FieldTypeEnum.PHONE);
        map.put("email", FieldTypeEnum.EMAIL);
        map.put("score", FieldTypeEnum.SCORE);
        map.put("location", FieldTypeEnum.LOCATION);
        map.put("unmapped_value", FieldTypeEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum FieldTypeEnum {

        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        PHONE("phone"),
        EMAIL("email"),
        SCORE("score"),
        LOCATION("location"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private FieldTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

