/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ScheduledInterviewValue
 * 
 * <p>The status of the interview.
 */
public class ScheduledInterviewValue {

    public static final ScheduledInterviewValue UNSCHEDULED = new ScheduledInterviewValue("unscheduled");
    public static final ScheduledInterviewValue SCHEDULED = new ScheduledInterviewValue("scheduled");
    public static final ScheduledInterviewValue COMPLETED = new ScheduledInterviewValue("completed");
    public static final ScheduledInterviewValue CANCELLED = new ScheduledInterviewValue("cancelled");
    public static final ScheduledInterviewValue PENDING_FEEDBACK = new ScheduledInterviewValue("pending_feedback");
    public static final ScheduledInterviewValue UNMAPPED_VALUE = new ScheduledInterviewValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ScheduledInterviewValue> values = createValuesMap();
    private static final Map<String, ScheduledInterviewValueEnum> enums = createEnumsMap();

    private final String value;

    private ScheduledInterviewValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ScheduledInterviewValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ScheduledInterviewValue
     */ 
    @JsonCreator
    public static ScheduledInterviewValue of(String value) {
        synchronized (ScheduledInterviewValue.class) {
            return values.computeIfAbsent(value, v -> new ScheduledInterviewValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ScheduledInterviewValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ScheduledInterviewValue other = (ScheduledInterviewValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ScheduledInterviewValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ScheduledInterviewValue[] values() {
        synchronized (ScheduledInterviewValue.class) {
            return values.values().toArray(new ScheduledInterviewValue[] {});
        }
    }

    private static final Map<String, ScheduledInterviewValue> createValuesMap() {
        Map<String, ScheduledInterviewValue> map = new LinkedHashMap<>();
        map.put("unscheduled", UNSCHEDULED);
        map.put("scheduled", SCHEDULED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("pending_feedback", PENDING_FEEDBACK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ScheduledInterviewValueEnum> createEnumsMap() {
        Map<String, ScheduledInterviewValueEnum> map = new HashMap<>();
        map.put("unscheduled", ScheduledInterviewValueEnum.UNSCHEDULED);
        map.put("scheduled", ScheduledInterviewValueEnum.SCHEDULED);
        map.put("completed", ScheduledInterviewValueEnum.COMPLETED);
        map.put("cancelled", ScheduledInterviewValueEnum.CANCELLED);
        map.put("pending_feedback", ScheduledInterviewValueEnum.PENDING_FEEDBACK);
        map.put("unmapped_value", ScheduledInterviewValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ScheduledInterviewValueEnum {

        UNSCHEDULED("unscheduled"),
        SCHEDULED("scheduled"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        PENDING_FEEDBACK("pending_feedback"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ScheduledInterviewValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

