/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TaskResultDataValue
 * 
 * <p>The unified value for the status of the task. If the provider does not specify this status, the
 * value will be set to UnmappedValue
 */
public class TaskResultDataValue {

    public static final TaskResultDataValue OPEN = new TaskResultDataValue("open");
    public static final TaskResultDataValue IN_PROGRESS = new TaskResultDataValue("in_progress");
    public static final TaskResultDataValue BLOCKED = new TaskResultDataValue("blocked");
    public static final TaskResultDataValue COMPLETED = new TaskResultDataValue("completed");
    public static final TaskResultDataValue CANCELLED = new TaskResultDataValue("cancelled");
    public static final TaskResultDataValue UNMAPPED_VALUE = new TaskResultDataValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TaskResultDataValue> values = createValuesMap();
    private static final Map<String, TaskResultDataValueEnum> enums = createEnumsMap();

    private final String value;

    private TaskResultDataValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TaskResultDataValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TaskResultDataValue
     */ 
    @JsonCreator
    public static TaskResultDataValue of(String value) {
        synchronized (TaskResultDataValue.class) {
            return values.computeIfAbsent(value, v -> new TaskResultDataValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TaskResultDataValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TaskResultDataValue other = (TaskResultDataValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TaskResultDataValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TaskResultDataValue[] values() {
        synchronized (TaskResultDataValue.class) {
            return values.values().toArray(new TaskResultDataValue[] {});
        }
    }

    private static final Map<String, TaskResultDataValue> createValuesMap() {
        Map<String, TaskResultDataValue> map = new LinkedHashMap<>();
        map.put("open", OPEN);
        map.put("in_progress", IN_PROGRESS);
        map.put("blocked", BLOCKED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskResultDataValueEnum> createEnumsMap() {
        Map<String, TaskResultDataValueEnum> map = new HashMap<>();
        map.put("open", TaskResultDataValueEnum.OPEN);
        map.put("in_progress", TaskResultDataValueEnum.IN_PROGRESS);
        map.put("blocked", TaskResultDataValueEnum.BLOCKED);
        map.put("completed", TaskResultDataValueEnum.COMPLETED);
        map.put("cancelled", TaskResultDataValueEnum.CANCELLED);
        map.put("unmapped_value", TaskResultDataValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TaskResultDataValueEnum {

        OPEN("open"),
        IN_PROGRESS("in_progress"),
        BLOCKED("blocked"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TaskResultDataValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

