/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class TimeEntriesValue {

    public static final TimeEntriesValue APPROVED = new TimeEntriesValue("approved");
    public static final TimeEntriesValue UNMAPPED_VALUE = new TimeEntriesValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeEntriesValue> values = createValuesMap();
    private static final Map<String, TimeEntriesValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeEntriesValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeEntriesValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeEntriesValue
     */ 
    @JsonCreator
    public static TimeEntriesValue of(String value) {
        synchronized (TimeEntriesValue.class) {
            return values.computeIfAbsent(value, v -> new TimeEntriesValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TimeEntriesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeEntriesValue other = (TimeEntriesValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeEntriesValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeEntriesValue[] values() {
        synchronized (TimeEntriesValue.class) {
            return values.values().toArray(new TimeEntriesValue[] {});
        }
    }

    private static final Map<String, TimeEntriesValue> createValuesMap() {
        Map<String, TimeEntriesValue> map = new LinkedHashMap<>();
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeEntriesValueEnum> createEnumsMap() {
        Map<String, TimeEntriesValueEnum> map = new HashMap<>();
        map.put("approved", TimeEntriesValueEnum.APPROVED);
        map.put("unmapped_value", TimeEntriesValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TimeEntriesValueEnum {

        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TimeEntriesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

