/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TimeOffBalancesValue
 * 
 * <p>The unified value for the duration unit. If the provider does not specify this unit, the value will
 * be set to unknown
 */
public class TimeOffBalancesValue {

    public static final TimeOffBalancesValue MINUTES = new TimeOffBalancesValue("minutes");
    public static final TimeOffBalancesValue HOURS = new TimeOffBalancesValue("hours");
    public static final TimeOffBalancesValue DAYS = new TimeOffBalancesValue("days");
    public static final TimeOffBalancesValue WEEKS = new TimeOffBalancesValue("weeks");
    public static final TimeOffBalancesValue MONTHS = new TimeOffBalancesValue("months");
    public static final TimeOffBalancesValue YEARS = new TimeOffBalancesValue("years");
    public static final TimeOffBalancesValue UNKNOWN = new TimeOffBalancesValue("unknown");
    public static final TimeOffBalancesValue UNMAPPED_VALUE = new TimeOffBalancesValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffBalancesValue> values = createValuesMap();
    private static final Map<String, TimeOffBalancesValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffBalancesValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffBalancesValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffBalancesValue
     */ 
    @JsonCreator
    public static TimeOffBalancesValue of(String value) {
        synchronized (TimeOffBalancesValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffBalancesValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TimeOffBalancesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffBalancesValue other = (TimeOffBalancesValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffBalancesValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffBalancesValue[] values() {
        synchronized (TimeOffBalancesValue.class) {
            return values.values().toArray(new TimeOffBalancesValue[] {});
        }
    }

    private static final Map<String, TimeOffBalancesValue> createValuesMap() {
        Map<String, TimeOffBalancesValue> map = new LinkedHashMap<>();
        map.put("minutes", MINUTES);
        map.put("hours", HOURS);
        map.put("days", DAYS);
        map.put("weeks", WEEKS);
        map.put("months", MONTHS);
        map.put("years", YEARS);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffBalancesValueEnum> createEnumsMap() {
        Map<String, TimeOffBalancesValueEnum> map = new HashMap<>();
        map.put("minutes", TimeOffBalancesValueEnum.MINUTES);
        map.put("hours", TimeOffBalancesValueEnum.HOURS);
        map.put("days", TimeOffBalancesValueEnum.DAYS);
        map.put("weeks", TimeOffBalancesValueEnum.WEEKS);
        map.put("months", TimeOffBalancesValueEnum.MONTHS);
        map.put("years", TimeOffBalancesValueEnum.YEARS);
        map.put("unknown", TimeOffBalancesValueEnum.UNKNOWN);
        map.put("unmapped_value", TimeOffBalancesValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TimeOffBalancesValueEnum {

        MINUTES("minutes"),
        HOURS("hours"),
        DAYS("days"),
        WEEKS("weeks"),
        MONTHS("months"),
        YEARS("years"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TimeOffBalancesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

