/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalBatchCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AccountingBatchCreateCompanyJournalsRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto;

    @JsonCreator
    public AccountingBatchCreateCompanyJournalsRequest(
            String xAccountId,
            String id,
            Optional<String> prefer,
            AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
    }
    
    public AccountingBatchCreateCompanyJournalsRequest(
            String xAccountId,
            String id,
            AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        this(xAccountId, id, Optional.empty(),
            accountingJournalBatchCreateRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto() {
        return accountingJournalBatchCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AccountingBatchCreateCompanyJournalsRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AccountingBatchCreateCompanyJournalsRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AccountingBatchCreateCompanyJournalsRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withAccountingJournalBatchCreateRequestDto(AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
        this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingBatchCreateCompanyJournalsRequest other = (AccountingBatchCreateCompanyJournalsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.accountingJournalBatchCreateRequestDto, other.accountingJournalBatchCreateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, prefer,
            accountingJournalBatchCreateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingBatchCreateCompanyJournalsRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "prefer", prefer,
                "accountingJournalBatchCreateRequestDto", accountingJournalBatchCreateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private Optional<String> prefer = Optional.empty();

        private AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder accountingJournalBatchCreateRequestDto(AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
            Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
            this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
            return this;
        }

        public AccountingBatchCreateCompanyJournalsRequest build() {

            return new AccountingBatchCreateCompanyJournalsRequest(
                xAccountId, id, prefer,
                accountingJournalBatchCreateRequestDto);
        }

    }
}
