/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateBackgroundCheckPackagesRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsCreateBackgroundCheckPackageRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto;

    @JsonCreator
    public AtsCreateBackgroundCheckPackageRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
    }
    
    public AtsCreateBackgroundCheckPackageRequest(
            String xAccountId,
            AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateBackgroundCheckPackagesRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto() {
        return atsCreateBackgroundCheckPackagesRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsCreateBackgroundCheckPackageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateBackgroundCheckPackageRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateBackgroundCheckPackageRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateBackgroundCheckPackageRequest withAtsCreateBackgroundCheckPackagesRequestDto(AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
        this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateBackgroundCheckPackageRequest other = (AtsCreateBackgroundCheckPackageRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateBackgroundCheckPackagesRequestDto, other.atsCreateBackgroundCheckPackagesRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateBackgroundCheckPackagesRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateBackgroundCheckPackageRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateBackgroundCheckPackagesRequestDto", atsCreateBackgroundCheckPackagesRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateBackgroundCheckPackagesRequestDto(AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
            Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
            this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
            return this;
        }

        public AtsCreateBackgroundCheckPackageRequest build() {

            return new AtsCreateBackgroundCheckPackageRequest(
                xAccountId, prefer, atsCreateBackgroundCheckPackagesRequestDto);
        }

    }
}
