/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateSmsTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class MarketingCreateSmsTemplateRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto;

    @JsonCreator
    public MarketingCreateSmsTemplateRequest(
            String xAccountId,
            Optional<String> prefer,
            MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
    }
    
    public MarketingCreateSmsTemplateRequest(
            String xAccountId,
            MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        this(xAccountId, Optional.empty(), marketingCreateSmsTemplateRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto() {
        return marketingCreateSmsTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MarketingCreateSmsTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingCreateSmsTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingCreateSmsTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingCreateSmsTemplateRequest withMarketingCreateSmsTemplateRequestDto(MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
        Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
        this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateSmsTemplateRequest other = (MarketingCreateSmsTemplateRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.marketingCreateSmsTemplateRequestDto, other.marketingCreateSmsTemplateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, marketingCreateSmsTemplateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingCreateSmsTemplateRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "marketingCreateSmsTemplateRequestDto", marketingCreateSmsTemplateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder marketingCreateSmsTemplateRequestDto(MarketingCreateSmsTemplateRequestDto marketingCreateSmsTemplateRequestDto) {
            Utils.checkNotNull(marketingCreateSmsTemplateRequestDto, "marketingCreateSmsTemplateRequestDto");
            this.marketingCreateSmsTemplateRequestDto = marketingCreateSmsTemplateRequestDto;
            return this;
        }

        public MarketingCreateSmsTemplateRequest build() {

            return new MarketingCreateSmsTemplateRequest(
                xAccountId, prefer, marketingCreateSmsTemplateRequestDto);
        }

    }
}
