/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreatePushTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class MarketingUpdatePushTemplateRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto;

    @JsonCreator
    public MarketingUpdatePushTemplateRequest(
            String xAccountId,
            String id,
            Optional<String> prefer,
            MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
    }
    
    public MarketingUpdatePushTemplateRequest(
            String xAccountId,
            String id,
            MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        this(xAccountId, id, Optional.empty(),
            marketingCreatePushTemplateRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto() {
        return marketingCreatePushTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MarketingUpdatePushTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingUpdatePushTemplateRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingUpdatePushTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingUpdatePushTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingUpdatePushTemplateRequest withMarketingCreatePushTemplateRequestDto(MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
        this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingUpdatePushTemplateRequest other = (MarketingUpdatePushTemplateRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.marketingCreatePushTemplateRequestDto, other.marketingCreatePushTemplateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, prefer,
            marketingCreatePushTemplateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingUpdatePushTemplateRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "prefer", prefer,
                "marketingCreatePushTemplateRequestDto", marketingCreatePushTemplateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private Optional<String> prefer = Optional.empty();

        private MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder marketingCreatePushTemplateRequestDto(MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
            Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
            this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
            return this;
        }

        public MarketingUpdatePushTemplateRequest build() {

            return new MarketingUpdatePushTemplateRequest(
                xAccountId, id, prefer,
                marketingCreatePushTemplateRequestDto);
        }

    }
}
